/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String removeInterpunction(String text) {
        String decomposed = Normalizer.normalize(text, Normalizer.Form.NFD);
        return decomposed.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String getNumbersAndDotsOnly(String number) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < number.length(); ++i) {
            char ch = number.charAt(i);
            if ((ch < '0' || ch > '9') && ch != '.') continue;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static boolean wildCardMatch(String pattern, String text) {
        boolean startsWithStar = pattern.charAt(0) == '*';
        boolean endsWithStar = pattern.charAt(pattern.length() - 1) == '*';
        String[] substrings = pattern.split("\\*");
        if (!startsWithStar && !text.startsWith(substrings[0])) {
            return false;
        }
        if (!endsWithStar && !text.endsWith(substrings[substrings.length - 1])) {
            return false;
        }
        String searchedString = text;
        for (String s : substrings) {
            int index = searchedString.indexOf(s);
            if (index == -1) {
                return false;
            }
            searchedString = searchedString.substring(index + s.length());
        }
        return true;
    }

    public static String repeat(String s, int num) {
        num = Math.max(0, num);
        StringBuilder sb = new StringBuilder(s.length() * num);
        for (int i = 0; i < num; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String convertFieldNameToLabel(String fieldId) {
        if (fieldId == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[a-z][A-Z]");
        Matcher matcher = pattern.matcher(fieldId);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group();
            String newValue = String.valueOf(group.charAt(0)) + " " + String.valueOf(group.charAt(1)).toLowerCase();
            matcher.appendReplacement(sb, newValue);
        }
        matcher.appendTail(sb);
        if (fieldId.length() > 0) {
            sb.replace(0, 1, fieldId.substring(0, 1).toUpperCase());
        }
        return sb.toString();
    }

    public static String arrayToString(String[] list, String separator) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            sb.append(list[i]);
            if (i == list.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

