/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.forms.FormElement;
import com.browsersoft.commander.utils.forms.FormElementHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class CheckBoxFormElement
extends JCheckBox
implements FormElement {
    private FormElementHandler handler;
    private String trueValue;
    private String falseValue;
    private boolean changed;

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public void enableEdit(boolean value) {
        this.setEnabled(value);
    }

    public CheckBoxFormElement(String trueValue, String falseValue) {
        this.trueValue = trueValue;
        this.falseValue = falseValue;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckBoxFormElement.this.generateChangeEvent();
            }
        });
    }

    @Override
    public void destroy() {
    }

    public String getTrueValue() {
        return this.trueValue;
    }

    public String getFalseValue() {
        return this.falseValue;
    }

    private void generateChangeEvent() {
        this.changed = true;
        if (this.handler != null) {
            this.handler.dataChanged();
        }
    }

    @Override
    public FormElementHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FormElementHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getFormValue() {
        if (this.isSelected()) {
            return this.trueValue;
        }
        return this.falseValue;
    }

    @Override
    public void setFormValue(String value) {
        if (value == null) {
            this.setSelected(false);
            return;
        }
        if (value.equals(this.trueValue)) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }
}

