/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.forms.ComboBoxFormElementItem;
import com.browsersoft.commander.utils.forms.FormElement;
import com.browsersoft.commander.utils.forms.FormElementHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class ComboBoxFormElement
extends JComboBox
implements FormElement {
    private FormElementHandler handler;
    private ArrayList<ComboBoxFormElementItem> items = new ArrayList();
    private boolean changed;

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public ComboBoxFormElement(String[] titles, String[] values) {
        for (int i = 0; i < titles.length; ++i) {
            ComboBoxFormElementItem item = new ComboBoxFormElementItem();
            item.setValue(values[i]);
            item.setTitle(titles[i]);
            this.items.add(item);
            this.addItem(item);
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComboBoxFormElement.this.generateChangeEvent();
            }
        });
    }

    @Override
    public void enableEdit(boolean value) {
        this.setEnabled(value);
    }

    private void generateChangeEvent() {
        if (this.handler != null) {
            this.handler.dataChanged();
        }
        this.changed = true;
    }

    @Override
    public FormElementHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FormElementHandler handler) {
        this.handler = handler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getFormValue() {
        ComboBoxFormElementItem item = (ComboBoxFormElementItem)this.getSelectedItem();
        if (item != null) {
            return item.getValue();
        }
        return "";
    }

    @Override
    public void setFormValue(String value) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).getValue().equals(value)) continue;
            this.setSelectedIndex(i);
        }
    }
}

