/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.ReflectionUtils;
import com.browsersoft.commander.utils.forms.CheckBoxFormElement;
import com.browsersoft.commander.utils.forms.ComboBoxFormElement;
import com.browsersoft.commander.utils.forms.DynamicComboItem;
import com.browsersoft.commander.utils.forms.FormCheckBox;
import com.browsersoft.commander.utils.forms.FormCombo;
import com.browsersoft.commander.utils.forms.FormDynamicCombo;
import com.browsersoft.commander.utils.forms.FormElement;
import com.browsersoft.commander.utils.forms.FormElementHandler;
import com.browsersoft.commander.utils.forms.FormParam;
import com.browsersoft.commander.utils.forms.FormTextArea;
import com.browsersoft.commander.utils.forms.NumberFormElement;
import com.browsersoft.commander.utils.forms.TextAreaFormElement;
import com.browsersoft.commander.utils.forms.TextFieldFormElement;
import com.browsersoft.commander.utils.forms.ValidFormObjectWithCombo;
import com.browsersoft.commander.utils.swing.TwoColumnsLayout;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FormPanel
extends JPanel
implements FormElementHandler {
    private FormElementHandler handler;
    private Map<String, FormElement> components = new HashMap<String, FormElement>();
    private Object o;

    public FormPanel(Object o, int firstColumnSize, FormElementHandler handler) throws Exception {
        this.handler = handler;
        this.initForm(o, firstColumnSize);
    }

    public FormPanel(Object o, int firstColumnSize) throws Exception {
        this.initForm(o, firstColumnSize);
    }

    private void initForm(Object o, int firstColumnSize) throws Exception {
        this.o = o;
        TwoColumnsLayout twoColumnsLayout = new TwoColumnsLayout(firstColumnSize, 10, 10);
        this.setLayout(twoColumnsLayout);
        List<Field> fields = ReflectionUtils.getDeclaredFieldsWithSpecificAnotation(o.getClass(), FormParam.class);
        for (Field field : fields) {
            NumberFormElement numberFormElement;
            field.setAccessible(true);
            FormParam formParam = field.getAnnotation(FormParam.class);
            String title = formParam.value();
            JLabel label = new JLabel("<html>" + title + "</html>");
            label.setVerticalAlignment(1);
            this.add(label);
            Class<?> aClass = field.getType();
            if (aClass.equals(String.class)) {
                FormCombo formCombo = field.getAnnotation(FormCombo.class);
                FormTextArea formTextArea = field.getAnnotation(FormTextArea.class);
                FormCheckBox formCheckBox = field.getAnnotation(FormCheckBox.class);
                FormDynamicCombo formDynamicCombo = field.getAnnotation(FormDynamicCombo.class);
                if (formCombo != null) {
                    ComboBoxFormElement comboBoxFormElement = new ComboBoxFormElement(formCombo.titles(), formCombo.values());
                    comboBoxFormElement.setHandler(this);
                    comboBoxFormElement.setFormValue((String)field.get(o));
                    this.add(comboBoxFormElement);
                    this.components.put(field.getName(), comboBoxFormElement);
                    continue;
                }
                if (formTextArea != null) {
                    TextAreaFormElement textAreaFormElement = new TextAreaFormElement();
                    textAreaFormElement.setHandler(this);
                    textAreaFormElement.setFormValue((String)field.get(o));
                    textAreaFormElement.setPreferredSize(new Dimension(20, 100));
                    this.add(textAreaFormElement);
                    this.components.put(field.getName(), textAreaFormElement);
                    continue;
                }
                if (formCheckBox != null) {
                    CheckBoxFormElement checkBoxFormElement = new CheckBoxFormElement(formCheckBox.trueValue(), formCheckBox.falseValue());
                    checkBoxFormElement.setHandler(this);
                    checkBoxFormElement.setFormValue((String)field.get(o));
                    this.add(checkBoxFormElement);
                    this.components.put(field.getName(), checkBoxFormElement);
                    continue;
                }
                if (formDynamicCombo != null) {
                    List<DynamicComboItem> dynamicComboItems;
                    if (this.o instanceof ValidFormObjectWithCombo) {
                        System.out.println("ValidFormObjectWithCombo");
                        dynamicComboItems = ((ValidFormObjectWithCombo)this.o).getComboItems(formDynamicCombo.value());
                    } else {
                        System.out.println("NOT ValidFormObjectWithCombo");
                        dynamicComboItems = this.handler.getComboValues(formDynamicCombo.value());
                    }
                    String[] values = new String[dynamicComboItems.size()];
                    String[] titles = new String[dynamicComboItems.size()];
                    for (int i = 0; i < dynamicComboItems.size(); ++i) {
                        DynamicComboItem dynamicComboItem = dynamicComboItems.get(i);
                        values[i] = dynamicComboItem.getValue();
                        titles[i] = dynamicComboItem.getName();
                    }
                    ComboBoxFormElement comboBoxFormElement = new ComboBoxFormElement(titles, values);
                    comboBoxFormElement.setHandler(this);
                    comboBoxFormElement.setFormValue((String)field.get(o));
                    this.add(comboBoxFormElement);
                    this.components.put(field.getName(), comboBoxFormElement);
                    continue;
                }
                TextFieldFormElement textFieldFormElement = new TextFieldFormElement();
                textFieldFormElement.setHandler(this);
                textFieldFormElement.setFormValue((String)field.get(o));
                this.add(textFieldFormElement);
                this.components.put(field.getName(), textFieldFormElement);
                continue;
            }
            if (aClass.equals(Integer.TYPE)) {
                numberFormElement = new NumberFormElement();
                numberFormElement.setHandler(this);
                numberFormElement.setFormValue(String.valueOf(field.getInt(o)));
                this.add(numberFormElement);
                this.components.put(field.getName(), numberFormElement);
                continue;
            }
            if (aClass.equals(Integer.class)) {
                numberFormElement = new NumberFormElement();
                numberFormElement.setHandler(this);
                numberFormElement.setFormValue(String.valueOf((Integer)field.get(o)));
                this.add(numberFormElement);
                this.components.put(field.getName(), numberFormElement);
                continue;
            }
            if (!aClass.equals(Boolean.TYPE) && !aClass.equals(Boolean.class)) continue;
            CheckBoxFormElement checkBoxFormElement = new CheckBoxFormElement("true", "false");
            checkBoxFormElement.setHandler(this);
            if (field.getBoolean(o)) {
                checkBoxFormElement.setFormValue("true");
            } else {
                checkBoxFormElement.setFormValue("false");
            }
            this.add(checkBoxFormElement);
            this.components.put(field.getName(), checkBoxFormElement);
        }
        this.setPreferredSize(new Dimension(firstColumnSize * 3, this.getPreferredSize().height));
    }

    @Override
    public List<DynamicComboItem> getComboValues(String id) {
        return null;
    }

    @Override
    public void dataChanged() {
        try {
            List<Field> fields = ReflectionUtils.getDeclaredFieldsWithSpecificAnotation(this.o.getClass(), FormParam.class);
            Set<String> fieldNames = this.components.keySet();
            for (String fieldName : fieldNames) {
                FormElement formElement = this.components.get(fieldName);
                Field field = this.getField(fields, fieldName);
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(this.o, formElement.getFormValue());
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    CheckBoxFormElement checkBoxFormElement = (CheckBoxFormElement)formElement;
                    field.setBoolean(this.o, checkBoxFormElement.getFormValue().equals(checkBoxFormElement.getTrueValue()));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    try {
                        field.setInt(this.o, Integer.parseInt(formElement.getFormValue()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!field.getType().equals(Integer.class)) continue;
                try {
                    field.set(this.o, new Integer(Integer.parseInt(formElement.getFormValue())));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.handler != null) {
                this.handler.dataChanged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Field getField(List<Field> fields, String name) {
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public FormElementHandler getHandler() {
        return this.handler;
    }

    public void setHandler(FormElementHandler handler) {
        this.handler = handler;
    }
}

