/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.forms.FormElement;
import com.browsersoft.commander.utils.forms.FormElementHandler;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;

public class NumberFormElement
extends JSpinner
implements FormElement {
    private FormElementHandler handler;
    private boolean changed;

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public NumberFormElement() {
        super(new SpinnerNumberModel(0.0, -9.223372036854776E18, 9.223372036854776E18, 1.0));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor((JSpinner)this, "#");
        this.setEditor(editor);
        JFormattedTextField tf = editor.getTextField();
        tf.setHorizontalAlignment(2);
        DefaultFormatter formatter = (DefaultFormatter)tf.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberFormElement.this.generateChangeEvent();
            }
        });
        this.setFont(new Font("Arial Unicode MS", 0, 11));
        tf.setBackground(new Color(231, 231, 231));
    }

    private void generateChangeEvent() {
        if (this.handler != null) {
            this.handler.dataChanged();
        }
        this.changed = true;
    }

    @Override
    public void enableEdit(boolean value) {
        this.setEnabled(value);
    }

    @Override
    public void destroy() {
    }

    @Override
    public FormElementHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FormElementHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getFormValue() {
        Object value = this.getValue();
        if (value instanceof Double) {
            value = ((Double)value).longValue();
        } else if (value instanceof Float) {
            value = ((Float)value).longValue();
        }
        return String.valueOf(value);
    }

    @Override
    public void setFormValue(String value) {
        try {
            this.setValue(Integer.parseInt(value));
        }
        catch (Exception e) {
            this.setValue(0);
        }
    }
}

