/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.CenteredDialog;
import com.browsersoft.commander.utils.forms.ValidFormObject;
import com.browsersoft.commander.utils.swing.KeyBuffer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class SimpleDialogWithPanel
extends CenteredDialog {
    private boolean ok;
    private JPanel panel;
    private JButton buttonCancel;
    private JButton buttonOK;
    private final ValidFormObject formObject;
    private JPanel panelContainer;
    private JLabel errorTextField;

    public SimpleDialogWithPanel(Frame parent, String title, JPanel panel, ValidFormObject formObject) {
        super(parent, true);
        this.panel = panel;
        this.formObject = formObject;
        this.initComponents();
        int newDialogWidth = this.getWidth() + (panel.getPreferredSize().width - this.panelContainer.getWidth());
        int newDialogHeight = this.getHeight() + (panel.getPreferredSize().height - this.panelContainer.getHeight());
        this.setSize(newDialogWidth, newDialogHeight);
        this.setResizable(false);
        this.panelContainer.add(panel);
        this.centerParent();
        this.setTitle(title);
    }

    public boolean isOK() {
        return this.ok;
    }

    private void showErrorMsg(String text) {
        this.errorTextField.setText(text);
        this.errorTextField.setVisible(true);
        this.revalidate();
        this.pack();
    }

    private void doOK() {
        if (!this.formObject.isValidForm()) {
            this.showErrorMsg("Some input elements cannot be empty or contain forbidden characters.");
            return;
        }
        this.ok = true;
        this.dispose();
    }

    private void doCancel() {
        this.ok = false;
        this.dispose();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void initComponents() {
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.panelContainer = new JPanel(new BorderLayout());
        this.errorTextField = new JLabel();
        this.errorTextField.setVisible(false);
        this.errorTextField.setForeground(Color.RED);
        this.errorTextField.setFont(new Font("Arial Unicode MS", 0, 12));
        this.setDefaultCloseOperation(2);
        this.setTitle("");
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(evt -> this.doOK());
        this.buttonOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleDialogWithPanel.this.buttonOKKeyPressed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(evt -> this.doCancel());
        this.buttonCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleDialogWithPanel.this.buttonCancelKeyPressed(evt);
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDialogWithPanel.this.doCancel();
            }
        });
        KeyBuffer.installKey(this.getRootPane(), 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDialogWithPanel.this.doOK();
            }
        });
        this.panelContainer.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelContainer, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.errorTextField, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOK, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelContainer, -1, -1, Short.MAX_VALUE).addGap(7).addComponent(this.errorTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doCancel();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }

    private void buttonOKKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.doOK();
        } else if (evt.getKeyCode() == 27) {
            this.doCancel();
        }
    }
}

