/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.forms.FormElement;
import com.browsersoft.commander.utils.forms.FormElementHandler;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldFormElement
extends JTextField
implements FormElement {
    private FormElementHandler handler;
    private boolean changed;

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public TextFieldFormElement() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldFormElement.this.generateChangeEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldFormElement.this.generateChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldFormElement.this.generateChangeEvent();
            }
        });
        this.setFont(new Font("Arial Unicode MS", 0, 11));
        this.setBackground(new Color(231, 231, 231));
    }

    private void generateChangeEvent() {
        if (this.handler != null) {
            this.handler.dataChanged();
        }
        this.changed = true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void enableEdit(boolean value) {
        this.setEnabled(value);
    }

    @Override
    public FormElementHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FormElementHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getFormValue() {
        return this.getText();
    }

    @Override
    public void setFormValue(String value) {
        this.setText(value);
    }
}

