/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.forms;

import com.browsersoft.commander.utils.forms.TextAreaFormElement;

public class XmlListFormElement
extends TextAreaFormElement {
    private String defaultValue = null;
    private String defaultValueUpdated = null;
    private boolean defaultValueSet = false;
    private final String listItemStartElement;
    private final String listItemEndElement;

    public XmlListFormElement(String itemName) {
        if (itemName == null) {
            itemName = "item";
        }
        this.listItemStartElement = "<" + itemName + ">";
        this.listItemEndElement = "</" + itemName + ">";
    }

    @Override
    public String getFormValue() {
        String value = super.getFormValue();
        if (this.defaultValue != null && value != null && value.equals(this.defaultValueUpdated)) {
            return this.defaultValue;
        }
        return this.addListPropertyElements(value);
    }

    @Override
    public void setFormValue(String value) {
        String updatedValue = this.stripListPropertyElements(value);
        if (!this.defaultValueSet) {
            this.defaultValueSet = true;
            this.defaultValue = value;
            this.defaultValueUpdated = updatedValue;
        }
        super.setFormValue(updatedValue);
    }

    @Override
    public boolean isChanged() {
        String value = super.getFormValue();
        if (this.defaultValue != null && value != null && this.defaultValue.equals(value)) {
            return false;
        }
        return super.isChanged();
    }

    @Override
    protected String getDefaultValue() {
        return this.defaultValue;
    }

    protected String stripListPropertyElements(String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String localValue = value.trim();
        if (!localValue.startsWith(this.listItemStartElement)) {
            return value;
        }
        String ret = "";
        String[] items = localValue.split(this.listItemEndElement);
        for (int i = 0; i < items.length; ++i) {
            String item = items[i].trim();
            if (item.isEmpty()) continue;
            int index = 0;
            if (item.startsWith(this.listItemStartElement)) {
                index = this.listItemStartElement.length();
            }
            ret = ret + item.substring(index);
            if (i >= items.length - 1) continue;
            ret = ret + "\n";
        }
        return ret;
    }

    protected String addListPropertyElements(String value) {
        String[] items;
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        String ret = "";
        for (String item : items = value.split("\n")) {
            ret = ret + this.listItemStartElement + item.trim() + this.listItemEndElement + "\n";
        }
        return ret;
    }
}

