/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.prefs;

import com.browsersoft.commander.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class PreferencesNode {
    private Preferences preferences;
    private String prefix;

    public PreferencesNode(Class h, String prefix) {
        this.prefix = prefix;
        this.preferences = Preferences.userNodeForPackage(h);
    }

    public Preferences Preferences() {
        return this.preferences;
    }

    public void setItem(String name, Object o) throws IOException {
        if (o == null) {
            this.preferences.putByteArray(this.prefix + name, new byte[0]);
        } else {
            this.preferences.putByteArray(this.prefix + name, StreamUtils.serializeObjectToByteArray(o));
        }
    }

    public Object getItem(String name) throws ClassNotFoundException, IOException {
        byte[] bytes = this.preferences.getByteArray(this.prefix + name, null);
        if (bytes != null && bytes.length != 0) {
            return StreamUtils.deserializeByteArrayToObject(bytes);
        }
        return null;
    }

    public List<Object> getCollection(String name) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int count = this.preferences.getInt(this.prefix + name + "_count", 0);
        for (int i = 0; i < count; ++i) {
            byte[] bytes = this.preferences.getByteArray(this.prefix + name + "_" + i, null);
            if (bytes == null) continue;
            try {
                objects.add(StreamUtils.deserializeByteArrayToObject(bytes));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objects;
    }

    public List<Object> getCollection(String name, List<ClassLoader> classLoaders) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int count = this.preferences.getInt(this.prefix + name + "_count", 0);
        for (int i = 0; i < count; ++i) {
            ClassLoader classLoader = classLoaders.get(i);
            byte[] bytes = this.preferences.getByteArray(this.prefix + name + "_" + i, null);
            if (bytes == null) continue;
            try {
                Object o = StreamUtils.deserializeByteArrayToObject(bytes, classLoader);
                if (o == null) continue;
                objects.add(o);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objects;
    }

    private Object tryToLoad(byte[] bytes, List<ClassLoader> classLoaders) {
        try {
            return StreamUtils.deserializeByteArrayToObject(bytes);
        }
        catch (Exception exception) {
            for (ClassLoader classLoader : classLoaders) {
                try {
                    return StreamUtils.deserializeByteArrayToObject(bytes, classLoader);
                }
                catch (Exception exception2) {
                }
            }
            return null;
        }
    }

    public void setCollection(String name, List<Object> profiles) throws IOException {
        this.preferences.putInt(this.prefix + name + "_count", profiles.size());
        for (int i = 0; i < profiles.size(); ++i) {
            Object o = profiles.get(i);
            byte[] bytes = StreamUtils.serializeObjectToByteArray(o);
            this.preferences.putByteArray(this.prefix + name + "_" + i, bytes);
        }
    }

    public void exportPreferences(OutputStream outputStream) throws BackingStoreException, IOException {
        this.preferences.exportSubtree(outputStream);
    }

    public void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        BufferedInputStream is = new BufferedInputStream(inputStream);
        Preferences.importPreferences(is);
    }
}

