/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import com.browsersoft.commander.utils.swing.CloseableTabbedPaneHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class CloseableTabbedPane
extends JTabbedPane {
    private CloseableTabbedPaneHandler handler;

    public CloseableTabbedPane() {
        this.addChangeListener(e -> {
            if (this.handler != null) {
                this.handler.tabbedPanelChanged();
            }
        });
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(null, null, component);
        TabCloseButton closableTab = new TabCloseButton(this, true, icon, title);
        this.setTabComponentAt(this.getTabCount() - 1, closableTab);
        this.setSelectedIndex(this.getTabCount() - 1);
    }

    public CloseableTabbedPaneHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CloseableTabbedPaneHandler handler) {
        this.handler = handler;
    }

    class CloseIcon
    implements Icon {
        CloseIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.drawLine(1, 1, 6, 6);
            g.drawLine(7, 1, 1, 7);
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    public class TabCloseButton
    extends JPanel
    implements ActionListener {
        private JTabbedPane parentPane;
        private JLabel titleLabel;
        private Font plainFont;
        private Font boldFont;

        public TabCloseButton(JTabbedPane parentPane, boolean visible, Icon icon, String label) {
            super(new BorderLayout());
            this.plainFont = new Font("Arial Unicode MS", 0, 11);
            this.boldFont = new Font("Arial", 1, 11);
            this.parentPane = parentPane;
            this.setOpaque(false);
            JPanel gap = new JPanel();
            gap.setOpaque(false);
            gap.setPreferredSize(new Dimension(3, 3));
            JPanel panel = new JPanel();
            FlowLayout fl = new FlowLayout(4, 0, 0);
            fl.setAlignOnBaseline(true);
            panel.setLayout(fl);
            panel.setOpaque(false);
            this.titleLabel = new JLabel(label + " ");
            this.titleLabel.setFont(this.boldFont);
            panel.add(this.titleLabel);
            CloseIcon closeIcon = new CloseIcon();
            JButton btClose = new JButton(closeIcon);
            btClose.setBorderPainted(true);
            btClose.setRolloverEnabled(false);
            btClose.setVisible(visible);
            btClose.setContentAreaFilled(false);
            btClose.setUI(new BasicButtonUI());
            btClose.setPreferredSize(new Dimension(10, 10));
            panel.add(btClose);
            btClose.addActionListener(this);
            this.add((Component)gap, "North");
            this.add((Component)panel, "Center");
        }

        public void setTitle(String title) {
            this.titleLabel.setText(title + " ");
        }

        public JLabel getTitleLabel() {
            return this.titleLabel;
        }

        public void setBoldFont() {
            this.titleLabel.setFont(this.boldFont);
        }

        public void setPlainFont() {
            this.titleLabel.setFont(this.plainFont);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = this.parentPane.indexOfTabComponent(this);
            if (i != -1) {
                if (CloseableTabbedPane.this.handler != null) {
                    boolean decision = CloseableTabbedPane.this.handler.closeTab(i);
                    if (decision) {
                        this.parentPane.remove(i);
                        System.gc();
                    }
                } else {
                    this.parentPane.remove(i);
                    System.gc();
                }
            }
        }
    }
}

