/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import com.browsersoft.commander.utils.swing.KeyBufferHandler;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class KeyBuffer {
    private StringBuffer buffer = new StringBuffer();
    private int maxDistanceInMillis;
    private long lastPressedKeyTime = 0L;
    private KeyBufferHandler handler;

    public KeyBuffer(int maxDistanceInMillis) {
        this.maxDistanceInMillis = maxDistanceInMillis;
    }

    public void keyPressed(int character) {
        long now = System.currentTimeMillis();
        if (now - this.lastPressedKeyTime > (long)this.maxDistanceInMillis) {
            this.buffer = new StringBuffer();
        }
        this.lastPressedKeyTime = now;
        this.buffer.append((char)character);
        this.handler.keyBufferTextEvent(this.buffer.toString());
    }

    public KeyBufferHandler getHandler() {
        return this.handler;
    }

    public void setHandler(KeyBufferHandler handler) {
        this.handler = handler;
    }

    public static void installKey(JComponent component, int key, int modifierKeys, Action action) {
        InputMap inputMap = component.getInputMap(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key, modifierKeys);
        String actionMapKey = modifierKeys + "" + (char)key + "_pressed";
        inputMap.put(keyStroke, actionMapKey);
        component.getActionMap().put(actionMapKey, action);
    }
}

