/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalWrapLayout
implements LayoutManager {
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private int gapX;
    private int gapY;

    public VerticalWrapLayout(int gapX, int gapY) {
        this.gapX = gapX;
        this.gapY = gapY;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int parentWidth = parent.getParent().getSize().width;
        int X = this.gapX;
        int actualLineHeight = 0;
        int Y = this.gapY;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component comp = parent.getComponent(i);
            Dimension dim = comp.getPreferredSize();
            if ((double)X + dim.getWidth() < (double)(parentWidth - this.gapX)) {
                comp.setBounds(X, Y, (int)dim.getWidth(), (int)dim.getHeight());
                X = (int)((double)X + (dim.getWidth() + (double)this.gapX));
                if (!(dim.getHeight() > (double)actualLineHeight)) continue;
                actualLineHeight = (int)dim.getHeight();
                continue;
            }
            X = this.gapX;
            actualLineHeight = 0;
            comp.setBounds(X, Y += actualLineHeight + this.gapY, (int)dim.getWidth(), (int)dim.getHeight());
            X = (int)((double)X + (dim.getWidth() + (double)this.gapX));
            if (!(dim.getHeight() > (double)actualLineHeight)) continue;
            actualLineHeight = (int)dim.getHeight();
        }
        this.preferredHeight = Y + actualLineHeight + this.gapY;
        this.preferredWidth = parentWidth;
        this.minHeight = this.preferredHeight;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.preferredWidth;
        dim.height = this.preferredHeight;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        dim.width = this.minWidth;
        dim.height = this.minHeight;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.setSizes(parent);
        int parentWidth = parent.getParent().getSize().width;
        int X = this.gapX;
        int actualLineHeight = 0;
        int Y = this.gapY;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component comp = parent.getComponent(i);
            Dimension dim = comp.getPreferredSize();
            if ((double)X + dim.getWidth() < (double)(parentWidth - this.gapX)) {
                comp.setBounds(X, Y, (int)dim.getWidth(), (int)dim.getHeight());
                X = (int)((double)X + (dim.getWidth() + (double)this.gapX));
                if (!(dim.getHeight() > (double)actualLineHeight)) continue;
                actualLineHeight = (int)dim.getHeight();
                continue;
            }
            X = this.gapX;
            actualLineHeight = 0;
            comp.setBounds(X, Y += actualLineHeight + this.gapY, (int)dim.getWidth(), (int)dim.getHeight());
            X = (int)((double)X + (dim.getWidth() + (double)this.gapX));
            if (!(dim.getHeight() > (double)actualLineHeight)) continue;
            actualLineHeight = (int)dim.getHeight();
        }
    }
}

