/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VisualTable
extends JTable {
    private static final Color MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(8235754);
    private static final Color MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(8235754);
    private static final Color MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR = new Color(8235754);
    private static final Color MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(8235754);
    private static final Color MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(8235754);
    private static final Color MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(8235754);
    private static final Color MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(8235754);

    public VisualTable() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(true);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        if (rowCount * this.rowHeight < height) {
            for (int i = rowCount; i <= height / this.rowHeight; ++i) {
                g.setColor(this.colorForRow(i));
                g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
            }
            if (this.getShowVerticalLines()) {
                g.setColor(MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
                TableColumnModel columnModel = this.getColumnModel();
                int x = 0;
                for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                    TableColumn column = columnModel.getColumn(i);
                    g.drawLine((x += column.getWidth()) - 1, rowCount * this.rowHeight, x - 1, height);
                }
            }
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? this.alternateRowColor() : this.getBackground();
    }

    private Color alternateRowColor() {
        return new Color(250, 250, 250);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        boolean focused = this.hasFocus();
        boolean selected = this.isCellSelected(row, column);
        if (selected) {
            if (!focused) {
                c.setBackground(MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR);
                c.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c.setBackground(new Color(8235754));
                c.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
        } else {
            c.setBackground(this.colorForRow(row));
            c.setForeground(UIManager.getColor("Table.foreground"));
        }
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            if (c instanceof JCheckBox) {
                jc.setOpaque(true);
            }
            if (!this.getCellSelectionEnabled() && !this.isEditing()) {
                this.fixMacOsCellRendererBorder(jc, selected, focused);
            }
            this.initToolTip(jc, row, column);
        }
        return c;
    }

    private void fixMacOsCellRendererBorder(JComponent renderer, boolean selected, boolean focused) {
        Border border = selected ? BorderFactory.createMatteBorder(1, 0, 1, 0, focused ? MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR : MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR) : BorderFactory.createEmptyBorder(1, 0, 1, 0);
        if (this.getShowVerticalLines()) {
            Color verticalLineColor = focused ? (selected ? MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR : MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR) : (selected ? MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR : MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
            MatteBorder verticalBorder = BorderFactory.createMatteBorder(1, 0, 0, 1, verticalLineColor);
            border = BorderFactory.createCompoundBorder(border, verticalBorder);
        }
        renderer.setBorder(border);
    }

    private void initToolTip(JComponent c, int row, int column) {
        String toolTipText = null;
        if (c.getPreferredSize().width > this.getCellRect((int)row, (int)column, (boolean)false).width) {
            toolTipText = this.getValueAt(row, column).toString();
        }
        c.setToolTipText(toolTipText);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        if (this.getToolTipText(e) == null) {
            return null;
        }
        int row = this.rowAtPoint(e.getPoint());
        int column = this.columnAtPoint(e.getPoint());
        if (row == -1 || column == -1) {
            return null;
        }
        return this.getCellRect(row, column, false).getLocation();
    }
}

