/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.universal;

import com.browsersoft.commander.utils.universal.FieldEditor;
import com.browsersoft.commander.utils.universal.FieldEditorHandler;
import com.browsersoft.commander.utils.universal.InvalidValueException;
import com.browsersoft.commander.utils.universal.SliderToolTipDisplay;
import com.browsersoft.commander.utils.universal.SliderType;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderEditor
extends JSlider
implements FieldEditor {
    private FieldEditorHandler handler;
    private boolean changed;
    private SliderToolTipDisplay toolTipDisplay = new SliderToolTipDisplay(this);
    private int minInt;
    private int maxInt;
    private int incInt;
    private double minDouble;
    private double maxDouble;
    private double incDouble;
    private SliderType type;

    public SliderEditor() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderEditor.this.generateChangeEvent();
            }
        });
        this.setBackground(Color.WHITE);
        this.addMouseMotionListener(this.toolTipDisplay);
        this.addMouseListener(this.toolTipDisplay);
    }

    @Override
    public FieldEditorHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FieldEditorHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getEditorValue() {
        int sliderValue = this.getValue();
        if (this.type == SliderType.INTEGER) {
            return sliderValue;
        }
        if (this.type == SliderType.DOUBLE) {
            double extent = this.maxDouble - this.minDouble;
            return this.minDouble + (double)sliderValue / (double)(this.maxInt - this.minInt) * extent;
        }
        throw new IllegalStateException("SliderEditor has not been setup before calling getEditorValue() method.");
    }

    @Override
    public void setEditorValue(Object value) {
        if (this.type == null) {
            throw new IllegalStateException("SliderEditor has not been setup before calling setEditorValue() method.");
        }
        if (value instanceof Integer) {
            if (this.type == SliderType.INTEGER) {
                this.setValue((Integer)value);
            } else if (this.type == SliderType.DOUBLE) {
                double doubleValue = (Double)value;
                double extent = this.maxDouble - this.minDouble;
                double delta = doubleValue - this.minDouble;
                int intValue = (int)Math.round(delta / extent * 100.0);
                this.setValue(intValue);
            }
        } else if (value instanceof Double) {
            if (this.type == SliderType.INTEGER) {
                this.setValue((int)Math.round((Double)value));
            } else if (this.type == SliderType.DOUBLE) {
                double doubleValue = (Double)value;
                double extent = this.maxDouble - this.minDouble;
                double delta = doubleValue - this.minDouble;
                int intValue = (int)Math.round(delta / extent * 100.0);
                this.setValue(intValue);
            }
        } else {
            throw new InvalidValueException("SliderEditor does not support values of type: " + value.getClass());
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setEnabled(readOnly);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private void generateChangeEvent() {
        this.changed = true;
        this.toolTipDisplay.dataChanged();
        if (this.handler != null) {
            this.handler.dataChanged();
        }
    }

    public void setup(Number minValue, Number maxValue, Number increment) {
        if (minValue instanceof Integer && maxValue instanceof Integer && increment instanceof Integer) {
            this.type = SliderType.INTEGER;
            this.minInt = (Integer)minValue;
            this.maxInt = (Integer)maxValue;
            this.incInt = (Integer)increment;
            this.setMinimum(this.minInt);
            this.setMaximum(this.maxInt);
            this.setMajorTickSpacing(this.incInt);
        } else if (minValue instanceof Double && maxValue instanceof Double && increment instanceof Double) {
            this.type = SliderType.DOUBLE;
            this.minDouble = (Double)minValue;
            this.maxDouble = (Double)maxValue;
            this.incDouble = (Double)increment;
            int tickCount = (int)Math.floor((this.maxDouble - this.minDouble) / this.incDouble);
            this.minInt = 0;
            this.maxInt = 100;
            this.incInt = 100 / tickCount;
            this.setMinimum(this.minInt);
            this.setMaximum(this.maxInt);
            this.setMajorTickSpacing(this.incInt);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(this.minInt, new JLabel(this.createLabel(minValue)));
            labelTable.put(this.maxInt, new JLabel(this.createLabel(maxValue)));
            this.setLabelTable(labelTable);
        } else {
            throw new InvalidValueException("SliderEditor supports only Integer and Double types in its setup() method. Found types: " + minValue.getClass() + ", " + maxValue.getClass() + ", " + increment.getClass());
        }
    }

    private String createLabel(Number number) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        if (number instanceof Double || number instanceof Float) {
            return twoDForm.format(number);
        }
        if (number instanceof Long) {
            return Long.toString((Long)number);
        }
        throw new InvalidValueException("Forbidden object sent to createLabel method. Type of value: " + number.getClass());
    }

    public Number getMinValue() {
        if (this.type == SliderType.INTEGER) {
            return this.minInt;
        }
        if (this.type == SliderType.DOUBLE) {
            return this.minDouble;
        }
        return null;
    }

    public Number getMaxValue() {
        if (this.type == SliderType.INTEGER) {
            return this.maxInt;
        }
        if (this.type == SliderType.DOUBLE) {
            return this.maxDouble;
        }
        return null;
    }

    public Number getIncrement() {
        if (this.type == SliderType.INTEGER) {
            return this.incInt;
        }
        if (this.type == SliderType.DOUBLE) {
            return this.incDouble;
        }
        return null;
    }
}

