/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.universal;

import com.browsersoft.commander.utils.universal.FieldEditor;
import com.browsersoft.commander.utils.universal.FieldEditorHandler;
import com.browsersoft.commander.utils.universal.InvalidValueException;
import com.browsersoft.commander.utils.universal.SpinnerType;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerEditor
extends JSpinner
implements FieldEditor {
    private FieldEditorHandler handler;
    private boolean changed;
    private SpinnerNumberModel model;
    private SpinnerType type;

    public SpinnerEditor(SpinnerType type) {
        this.type = type;
        this.model = type == SpinnerType.DOUBLE || type == SpinnerType.FLOAT ? new SpinnerNumberModel((Number)0.0, null, null, (Number)0.0) : new SpinnerNumberModel((Number)0, null, null, (Number)1);
        this.setModel(this.model);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerEditor.this.generateChangeEvent();
            }
        });
    }

    @Override
    public FieldEditorHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FieldEditorHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getEditorValue() {
        Object value = super.getValue();
        switch (this.type) {
            case BYTE: {
                return Byte.valueOf(value.toString());
            }
            case SHORT: {
                return Short.valueOf(value.toString());
            }
            case INTEGER: {
                return Integer.valueOf(value.toString());
            }
            case LONG: {
                return Long.valueOf(value.toString());
            }
            case FLOAT: {
                return Float.valueOf(value.toString());
            }
            case DOUBLE: {
                return Double.valueOf(value.toString());
            }
        }
        return value;
    }

    @Override
    public void setEditorValue(Object value) {
        if (!(value instanceof Number)) {
            throw new InvalidValueException("SpinnerEditor does not support value of type: " + value.getClass());
        }
        super.setValue(value);
    }

    @Override
    public boolean isReadOnly() {
        return this.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setEnabled(readOnly);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private void generateChangeEvent() {
        this.changed = true;
        if (this.handler != null) {
            this.handler.dataChanged();
        }
    }

    public Number getStepSize() {
        return this.model.getStepSize();
    }

    public void setStepSize(Number stepSize) {
        this.model.setStepSize(stepSize);
    }

    public Comparable getMinimim() {
        return this.model.getMinimum();
    }

    public void setMinimum(Comparable minimum) {
        this.model.setMinimum(minimum);
    }

    public Comparable getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(Comparable maximum) {
        this.model.setMaximum(maximum);
    }
}

