/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.commander.utils.universal;

import com.browsersoft.commander.utils.HtmlUtils;
import com.browsersoft.commander.utils.universal.FieldEditor;
import com.browsersoft.commander.utils.universal.FieldEditorHandler;
import com.browsersoft.commander.utils.universal.InvalidValueException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringColorEditor
extends JPanel
implements FieldEditor {
    private FieldEditorHandler handler;
    private boolean changed;
    private boolean typingOn = true;
    private Color color = Color.WHITE;
    private JButton button = new JButton();
    private JTextField textField = new JTextField();
    private HtmlUtils htmlUtils = new HtmlUtils();

    public StringColorEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.button, "East");
        this.add(this.textField);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(StringColorEditor.this, "Choose Color", StringColorEditor.this.color);
                if (c != null && !c.equals(StringColorEditor.this.color)) {
                    StringColorEditor.this.color = c;
                    StringColorEditor.this.colorChanged();
                    StringColorEditor.this.generateChangeEvent();
                }
            }
        });
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (StringColorEditor.this.typingOn) {
                    StringColorEditor.this.generateChangeEvent();
                    StringColorEditor.this.tryToReadColor();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (StringColorEditor.this.typingOn) {
                    StringColorEditor.this.generateChangeEvent();
                    StringColorEditor.this.tryToReadColor();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (StringColorEditor.this.typingOn) {
                    StringColorEditor.this.generateChangeEvent();
                    StringColorEditor.this.tryToReadColor();
                }
            }
        });
    }

    private void tryToReadColor() {
        Color defaultColor;
        String colorString = this.textField.getText();
        final Color c = this.htmlUtils.getColor(colorString, defaultColor = new Color(1, 1, 1));
        if (c.equals(defaultColor) && !colorString.equals("010101")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringColorEditor.this.textField.setForeground(Color.RED);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringColorEditor.this.textField.setForeground(Color.BLACK);
                    StringColorEditor.this.color = c;
                    StringColorEditor.this.colorChanged();
                }
            });
        }
    }

    private void colorChanged() {
        this.typingOn = false;
        this.button.setBackground(this.color);
        this.textField.setText((String)this.getEditorValue());
        this.typingOn = true;
    }

    @Override
    public FieldEditorHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(FieldEditorHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getEditorValue() {
        return HtmlUtils.colorToHex(this.color).toUpperCase();
    }

    @Override
    public void setEditorValue(Object value) {
        if (!(value instanceof String)) {
            throw new InvalidValueException("StringColorEditor does not support value of type: " + value.getClass());
        }
        String stringValue = (String)value;
        this.color = this.htmlUtils.getColor(stringValue, Color.BLACK);
        this.colorChanged();
    }

    @Override
    public boolean isReadOnly() {
        return this.button.isEnabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.button.setEnabled(readOnly);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    private void generateChangeEvent() {
        this.changed = true;
        if (this.handler != null) {
            this.handler.dataChanged();
        }
    }
}

