/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EnginesGround;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Node;

public class EngineGround {
    private File file;
    private int port;
    private String engineId;
    private String externalId;
    private String releaseName;
    private String name;
    private UserInfo userInfo;
    private Date deployed;
    private File persistenceRoot;
    private EnginesGround enginesGround;

    public EngineGround(EnginesGround enginesGround) {
        this.enginesGround = enginesGround;
    }

    public EngineGround(File file) throws Exception {
        this.file = file;
        this.loadFromXml(DOMUtils.parseFile((String)new File(file, "engine.xml").getAbsolutePath()).getDocumentElement());
    }

    public EngineGround() {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public void loadFromXml(Node node) {
        Node userInfoNode;
        this.port = DOMUtils.getIntParameter((Node)node, (String)"port", (int)9999);
        this.engineId = DOMUtils.getParameter((Node)node, (String)"engineId");
        this.externalId = DOMUtils.getParameter((Node)node, (String)"externalId");
        this.name = DOMUtils.getParameter((Node)node, (String)"name");
        this.releaseName = DOMUtils.getParameter((Node)node, (String)"releaseName");
        long timestamp = DOMUtils.getLongParameter((Node)node, (String)"deployedTimestamp", (long)0L);
        if (timestamp > 0L) {
            this.deployed = new Date(timestamp);
        }
        if ((userInfoNode = DOMUtils.getOneNodeChild((Node)node, (String)"userInfo")) != null) {
            this.userInfo = UserInfo.fromXml(userInfoNode);
        }
    }

    public String saveToXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<engine\n");
        builder.append("    port=\"").append(this.port).append("\"\n");
        builder.append("    name=\"").append(DOMUtils.stringToEntity((String)this.name)).append("\"\n");
        builder.append("    externalId=\"").append(this.externalId).append("\"\n");
        builder.append("    engineId=\"").append(this.engineId).append("\"\n");
        builder.append("    releaseName=\"").append(this.releaseName).append("\"\n");
        if (this.deployed != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
            builder.append("    deployed=\"").append(dateFormat.format(this.deployed)).append("\"\n");
            builder.append("    deployedTimestamp=\"").append(this.deployed.getTime()).append("\"\n");
        }
        if (this.userInfo != null) {
            builder.append(">\n");
            String userInfoXml = this.userInfo.getXml();
            for (String line : userInfoXml.split("\n")) {
                builder.append("    ").append(line).append("\n");
            }
            builder.append("</engine>");
        } else {
            builder.append("/>");
        }
        return builder.toString();
    }

    public File getPersistenceRoot() {
        return this.persistenceRoot;
    }

    public void setPersistenceRoot(File persistenceRoot) {
        this.persistenceRoot = persistenceRoot;
    }

    public void deleteEngine() {
        this.enginesGround.deleteEngine(this.engineId);
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public Date getDeployed() {
        return this.deployed;
    }

    public void setDeployed(Date deployed) {
        this.deployed = deployed;
    }

    public byte[] readFile(String name) throws Exception {
        return FileUtils.loadFileToBytes((File)new File(this.file, name));
    }
}

