/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.UserInfoProvider;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.w3c.dom.Element;

public class EnginesGround {
    private static final String PERSISTENT_DIR_SUFFIX = "@persistent";
    private int minimumPort = 8311;
    private int maximumPort = 8399;
    private File root;

    public EnginesGround(File root) {
        this.root = root;
    }

    public synchronized EngineGround newEngine(String externalId, String name, String releaseName) throws Exception {
        EngineGround originalEngine = null;
        try {
            originalEngine = this.getEngineByExternalId(externalId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<EngineGround> infos = this.getEngines();
        int newPort = this.minimumPort;
        while (!this.checkPort(newPort, infos)) {
            if (++newPort != this.maximumPort) continue;
            throw new Exception("No free port available for control interface");
        }
        String engineDirName = externalId;
        if (engineDirName == null) {
            engineDirName = "engine_" + newPort;
        }
        EngineGround engineInfo = new EngineGround(this);
        engineInfo.setEngineId(originalEngine != null ? originalEngine.getEngineId() : UUID.randomUUID().toString());
        engineInfo.setFile(new File(this.root, engineDirName));
        engineInfo.setPersistenceRoot(new File(this.root, engineDirName + PERSISTENT_DIR_SUFFIX));
        engineInfo.setPort(originalEngine != null ? originalEngine.getPort() : newPort);
        engineInfo.setName(name);
        engineInfo.setReleaseName(releaseName);
        engineInfo.setExternalId(externalId);
        engineInfo.setUserInfo(UserInfoProvider.getUserInfo());
        engineInfo.setDeployed(new Date());
        if (engineInfo.getFile().exists()) {
            FileUtils.deleteDir((File)engineInfo.getFile());
        }
        engineInfo.getFile().mkdirs();
        engineInfo.getPersistenceRoot().mkdirs();
        File file = new File(engineInfo.getFile(), "engine.xml");
        FileUtils.saveBytesToFile((File)file, (byte[])engineInfo.saveToXml().getBytes("UTF-8"));
        return engineInfo;
    }

    public EngineGround newProjectEngine(File projectRoot, String name, String path, Integer engineNumber) throws Exception {
        int port = 8981;
        String runFolderName = "run";
        String persistentRootName = "run_persistent";
        String engineId = "PROJECT_ID";
        if (engineNumber != null && engineNumber >= 2) {
            port += engineNumber.intValue();
            runFolderName = runFolderName + String.valueOf(engineNumber);
            persistentRootName = persistentRootName + String.valueOf(engineNumber);
            engineId = String.format("%s_%d", engineId, engineNumber);
        }
        EngineGround engineInfo = new EngineGround(this);
        engineInfo.setEngineId(engineId);
        engineInfo.setFile(new File(projectRoot, runFolderName));
        engineInfo.setName(name);
        engineInfo.setPersistenceRoot(new File(projectRoot, persistentRootName));
        engineInfo.setPort(port);
        if (engineInfo.getFile().exists()) {
            FileUtils.deleteDir((File)engineInfo.getFile());
        }
        engineInfo.getFile().mkdir();
        File file = new File(engineInfo.getFile(), "engine.xml");
        FileUtils.saveBytesToFile((File)file, (byte[])engineInfo.saveToXml().getBytes("UTF-8"));
        File redeployTxt = new File(engineInfo.getFile(), "redeploy.txt");
        FileUtils.saveBytesToFile((File)redeployTxt, (byte[])path.getBytes("UTF-8"));
        return engineInfo;
    }

    private boolean checkPort(int port, List<EngineGround> infos) {
        for (EngineGround engineInfo : infos) {
            if (engineInfo.getPort() != port) continue;
            return false;
        }
        return true;
    }

    public List<EngineGround> getEngines() {
        ArrayList<EngineGround> ret = new ArrayList<EngineGround>();
        for (File file : this.root.listFiles()) {
            if (!file.isDirectory()) continue;
            try {
                EngineGround engineInfo = this.constructInfo(file);
                if (engineInfo == null) continue;
                ret.add(engineInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public EngineGround getEngine(String engineId) throws Exception {
        List<EngineGround> engines = this.getEngines();
        for (EngineGround engineGround : engines) {
            if (!engineGround.getEngineId().equals(engineId)) continue;
            return engineGround;
        }
        throw new Exception("Unknown id");
    }

    public EngineGround getEngineByExternalId(String externalId) throws Exception {
        List<EngineGround> engines = this.getEngines();
        for (EngineGround engineGround : engines) {
            if (engineGround.getExternalId() == null || !engineGround.getExternalId().equals(externalId)) continue;
            return engineGround;
        }
        throw new Exception("Unknown external id");
    }

    private EngineGround constructInfo(File engineRoot) throws Exception {
        File file = new File(engineRoot, "engine.xml");
        if (!file.exists()) {
            return null;
        }
        Element node = DOMUtils.parseFile((String)file.getAbsolutePath()).getDocumentElement();
        EngineGround newEngineInfo = new EngineGround(this);
        newEngineInfo.loadFromXml(node);
        newEngineInfo.setFile(engineRoot);
        newEngineInfo.setPersistenceRoot(new File(engineRoot.getParentFile(), engineRoot.getName() + PERSISTENT_DIR_SUFFIX));
        return newEngineInfo;
    }

    public synchronized void deleteEngine(String engineId) {
        List<EngineGround> infos = this.getEngines();
        for (EngineGround engineInfo : infos) {
            if (!engineInfo.getEngineId().equals(engineId)) continue;
            FileUtils.deleteDir((File)engineInfo.getFile());
            if (engineInfo.getPersistenceRoot().exists() && !engineInfo.getPersistenceRoot().equals(this.root)) {
                FileUtils.deleteDir((File)engineInfo.getPersistenceRoot());
            }
            return;
        }
    }

    public File getRoot() {
        return this.root;
    }
}

