/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.config.api.ReleaseNodeProxy;
import com.browsersoft.config.jgate.SocketGateNode;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.XTrustProvider;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.UUID;

public class TestProxy {
    public static void main(String[] args) throws Exception {
        XTrustProvider.install();
        GateNodeConfiguration gateNodeConfiguration = new GateNodeConfiguration();
        gateNodeConfiguration.addInt("DISABLE_CLIENT_CALLING", 1);
        SocketGateNode httpGateNode = new SocketGateNode(gateNodeConfiguration);
        GateNodeProxy gateNodeProxy = httpGateNode.connect("https://localhost:8020", "admin", "");
        ReleaseNodeProxy proxy = (ReleaseNodeProxy)gateNodeProxy.getProxy();
        System.out.println("Remote version: " + proxy.getVersion());
        File file = new File("node/lib/utils.jar");
        long fileSize = file.length();
        String fileHash = Hash.toHex((byte[])Hash.forFile((File)file));
        for (int i = 0; i < 10; ++i) {
            String fileName = UUID.randomUUID().toString();
            System.out.println("Uploading file '" + file.getName() + "' with size '" + fileSize + "' as '" + fileName + "'");
            System.out.println("Start at " + System.currentTimeMillis());
            try (FileInputStream in = new FileInputStream(file);){
                proxy.uploadUpdateFile(fileName, fileHash, new SizedInputStream((InputStream)in, fileSize), null);
            }
            System.out.println("Finished at " + System.currentTimeMillis());
            long size = proxy.getJarSize(fileName);
            System.out.println("Found jar size '" + size + "'");
            if (fileSize == size) continue;
            System.out.println("!!! Different " + size + " x " + fileSize);
        }
    }

    private static boolean uploadJar(ReleaseNodeProxy proxy, String name) throws Exception {
        return true;
    }

    private static String[] getNodeJarsList() throws IOException {
        ArrayList<String> jars = new ArrayList<String>();
        try (InputStream in = TestProxy.class.getResourceAsStream("/com/browsersoft/config/api/node-jars.txt");){
            String line;
            if (in == null) {
                throw new IOException("node-jars.txt not found!");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                jars.add(line);
            }
        }
        return jars.toArray(new String[0]);
    }
}

