/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api;

import com.browsersoft.binding.WorldsBindingStepRequestHandler;
import com.browsersoft.config.api.Deployment;
import com.browsersoft.config.api.TransferableFileStorage;
import com.browsersoft.config.api.hub.ConfigDir;
import com.browsersoft.config.api.hub.JarRecord;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.HashException;
import com.browsersoft.config.utils.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorldBindingUtils {
    public static List<String> deployJarsToFolder(File destination, List<JarRecord> jarRecords, TransferableFileStorage fileStorage) throws Exception {
        List<String> files = WorldBindingUtils.getJarsFiles(jarRecords, fileStorage);
        for (String fileAbs : files) {
            File file = new File(fileAbs);
            File newFile = new File(destination, file.getName());
            FileUtils.copyFile2File((File)file, (File)newFile);
        }
        return files;
    }

    public static Class loadEngineClass(ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass("com.browsersoft.medicalflow.MedicalBoxManager");
    }

    public static String runStep(Class engineMainClass, String xml, String dir, Map<String, Object> context, WorldsBindingStepRequestHandler target) throws Exception {
        Method method = engineMainClass.getMethod("worldsBindingRunStep", String.class, String.class, Map.class, WorldsBindingStepRequestHandler.class);
        return (String)method.invoke(null, xml, dir, context, target);
    }

    public static void deployDeploymentToFolder(File destination, Deployment deployment, TransferableFileStorage dirStorage) throws Exception {
        File profile = new File(destination, "profile.xml");
        FileUtils.saveBytesToFile((File)profile, (byte[])deployment.getProfile().getBytes("UTF-8"));
        File config = new File(destination, "config.xml");
        FileUtils.saveBytesToFile((File)config, (byte[])deployment.getConfig().getBytes("UTF-8"));
        File info = new File(destination, "info.xml");
        FileUtils.saveBytesToFile((File)info, (byte[])("<info>" + deployment.getReleaseName() + "</info>").getBytes("UTF-8"));
        StringBuilder configDirsToWatch = new StringBuilder();
        for (ConfigDir configDir : deployment.getDirs()) {
            File targetDir = new File(destination, configDir.getIdInDeployment());
            targetDir.mkdir();
            if (configDir.getSourceDir() != null && configDir.getSourceDir().exists()) {
                FileUtils.copyDirDeep((String)configDir.getSourceDir().getAbsolutePath(), (String)targetDir.getAbsolutePath());
                configDirsToWatch.append(configDir.getSourceDir().getAbsolutePath()).append(">").append(targetDir.getAbsolutePath()).append("\n");
                continue;
            }
            File file = dirStorage.get(configDir);
            if (file == null) {
                throw new Exception("Unknown dir : " + configDir.getName());
            }
            ZipUtil.unpackZip((InputStream)new FileInputStream(file), (File)targetDir, (boolean)false);
        }
        if (configDirsToWatch.length() > 0) {
            File syncDevelWatcher = new File(destination, "watcher.txt");
            FileUtils.saveBytesToFile((File)syncDevelWatcher, (byte[])configDirsToWatch.toString().getBytes("UTF-8"));
        }
    }

    public static List<String> getJarsFiles(List<JarRecord> jarRecords, TransferableFileStorage fileStorage) throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        for (JarRecord jarRecord : jarRecords) {
            File file = fileStorage.get(jarRecord);
            if (file == null) {
                throw new Exception("Unknown jar : " + jarRecord.getName());
            }
            files.add(file.getAbsolutePath());
        }
        return files;
    }

    public static File getModelDir(File rootDir) throws Exception {
        return new File(rootDir, "hieengine_config/src/com/browsersoft/config/modules");
    }

    public static ClassLoader getDevelClassLoader(File rootDir) throws Exception {
        List<String> classPathItems = WorldBindingUtils.getDevelReleaseClasspath(rootDir);
        return WorldBindingUtils.getClassLoaderFromFileList(classPathItems);
    }

    public static ClassLoader getClassLoaderFromFileList(List<String> files) throws Exception {
        URL[] urls = new URL[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            urls[i] = new File(files.get(i)).toURI().toURL();
        }
        return new URLClassLoader(urls, WorldBindingUtils.class.getClassLoader());
    }

    public static List<String> getDevelReleaseClasspath(File rootDir) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        File classPathFile = new File(rootDir + "/build/libraries/idea-classpath.xml");
        Element root = DOMUtils.parseFile((String)classPathFile.getAbsolutePath()).getDocumentElement();
        List items = DOMUtils.getNodeChilds((Node)root);
        for (Node node : items) {
            ret.add(new File(rootDir, DOMUtils.getTextContent((Node)node)).getAbsolutePath());
        }
        return ret;
    }

    public static List<JarRecord> getReleaseJars(File rootDir) throws Exception {
        ArrayList<JarRecord> ret = new ArrayList<JarRecord>();
        File classPathFile = new File(rootDir + "/build/libraries/classpath.xml");
        Element root = DOMUtils.parseFile((String)classPathFile.getAbsolutePath()).getDocumentElement();
        List items = DOMUtils.getNodeChilds((Node)root);
        for (Node node : items) {
            File jarFile = new File(rootDir, DOMUtils.getTextContent((Node)node));
            ret.add(WorldBindingUtils.createJarRecord(jarFile));
        }
        return ret;
    }

    public static JarRecord createJarRecord(File file) throws HashException {
        JarRecord jarInfo = new JarRecord();
        jarInfo.setJarFile(file);
        return jarInfo;
    }
}

