/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.control;

import com.browsersoft.config.api.AsyncEngineProcess;
import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.LocalEngineRun;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.api.UserInfoProvider;
import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemFactory;
import java.io.File;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ControlProcess {
    private static volatile boolean consoleKeepRunning = true;
    private static final String[] options = new String[]{"start", "stop", "kill", "status", "restart", "runCommand", "console"};

    public static void main(String[] args) throws Exception {
        CommandLine cmd = ControlProcess.handleArgs(args);
        String javaBinDir = cmd.getOptionValue("javaBinDir", "");
        String rootDir = cmd.getOptionValue("root", ".");
        String command = cmd.getArgs()[0];
        args = new String[cmd.getArgs().length - 1];
        System.arraycopy(cmd.getArgs(), 1, args, 0, args.length);
        EngineGround engineGround = new EngineGround(new File(rootDir));
        OperatingSystem operatingSystem = OperatingSystemFactory.getCurrentOperatingSystem(javaBinDir, null, null);
        LocalEngineRun localEngineRun = new LocalEngineRun(operatingSystem, engineGround);
        AsyncEngineProcess asyncEngineProcess = new AsyncEngineProcess(localEngineRun);
        if (command.equals("start")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.startProcess(userInfo);
            System.out.println("ok");
            while (asyncEngineProcess.getState() == EngineProcessState.STOPPED) {
                Thread.sleep(100L);
            }
            System.exit(0);
        } else if (command.equals("stop")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.stopProcess(userInfo);
            System.out.println("ok");
        } else if (command.equals("kill")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.killProcess(userInfo);
            System.out.println("ok");
        } else if (command.equals("restart")) {
            UserInfo userInfo = UserInfoProvider.getUserInfo();
            asyncEngineProcess.restartProcess(userInfo);
            while (asyncEngineProcess.getState() == EngineProcessState.STOPPED) {
                Thread.sleep(100L);
            }
            System.out.println("ok");
        } else if (command.equals("runCommand")) {
            ControlProcess.runCommand(localEngineRun, asyncEngineProcess, args);
        } else if (command.equals("console")) {
            ControlProcess.getConsole(asyncEngineProcess);
        } else if (command.equals("status")) {
            System.out.println(asyncEngineProcess.getState().toString());
        }
    }

    private static CommandLine handleArgs(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("j", "javaBinDir", true, "Path to java bin directory");
        options.addOption("r", "root", true, "Engine root");
        options.addOption("h", "help", false, "Show this help");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        boolean optionFound = false;
        if (cmd.getArgs().length > 0) {
            String option = cmd.getArgs()[0];
            for (String allowedOption : ControlProcess.options) {
                if (!option.equals(allowedOption)) continue;
                optionFound = true;
            }
        }
        if (!optionFound || args.length == 0 || cmd.getArgs().length == 0 || cmd.hasOption("h")) {
            String usage = ControlProcess.class.getSimpleName() + " [options] ";
            usage = usage + "<";
            for (int i = 0; i < ControlProcess.options.length; ++i) {
                usage = usage + ControlProcess.options[i];
                if (i >= ControlProcess.options.length - 1) continue;
                usage = usage + "|";
            }
            usage = usage + ">";
            HelpFormatter formater = new HelpFormatter();
            formater.setOptionComparator(null);
            formater.printHelp(usage, options, false);
            System.exit(1);
        }
        return cmd;
    }

    private static void getConsole(AsyncEngineProcess asyncEngineProcess) throws Exception {
        String lastMessageId = "";
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                consoleKeepRunning = false;
            }
        });
        while (consoleKeepRunning) {
            List<Message> messages = asyncEngineProcess.getConsole(lastMessageId);
            for (Message message : messages) {
                lastMessageId = message.getId();
                System.out.println(message.getValue());
            }
            Thread.sleep(200L);
        }
    }

    private static void runCommand(LocalEngineRun localEngineRun, AsyncEngineProcess asyncEngineProcess, String[] args) throws Exception {
        localEngineRun.executeEngineCommand(ControlProcess.argumentsToString(args));
        List<Message> messages = asyncEngineProcess.getConsole("");
        for (Message message : messages) {
            System.out.println(message.getValue());
        }
    }

    private static String argumentsToString(String[] args) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            stringBuilder.append(args[i]);
            if (i == args.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

