/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import com.browsersoft.config.api.hub.TransferableFileInfo;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.ZipUtil;
import java.io.File;
import java.io.Serializable;

public class ConfigDir
implements Serializable,
TransferableFileInfo {
    private String folderHash;
    private String name;
    private String type;
    private long size;
    private File sourceDir;
    private String sourceRecordHash;
    private String idInDeployment;

    public ConfigDir(File sourceDir, String name, String type) {
        this.sourceDir = sourceDir;
        this.name = name;
        this.type = type;
    }

    public ConfigDir(File sourceDir, String name, String type, String sourceRecordHash) {
        this.sourceDir = sourceDir;
        this.name = name;
        this.type = type;
        this.sourceRecordHash = sourceRecordHash;
    }

    public void beforeSerialization() throws Exception {
        byte[] bytes = ZipUtil.zipDir((String)this.sourceDir.getAbsolutePath());
        this.folderHash = Hash.toHex((byte[])Hash.forByteArray((byte[])bytes));
        this.size = bytes.length;
        this.sourceDir = null;
    }

    public boolean needDownload() {
        return this.sourceDir == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Override
    public String toCacheName() {
        return this.name + "-" + this.folderHash;
    }

    @Override
    public String getHash() {
        return this.folderHash;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getSourceRecordHash() {
        return this.sourceRecordHash;
    }

    public void setSourceRecordHash(String sourceRecordHash) {
        this.sourceRecordHash = sourceRecordHash;
    }

    public String getIdInDeployment() {
        return this.idInDeployment;
    }

    public void setIdInDeployment(String idInDeployment) {
        this.idInDeployment = idInDeployment;
    }
}

