/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.hub;

import com.browsersoft.config.api.hub.ConfigItemLink;
import com.browsersoft.config.api.hub.ConfigItemRecordType;
import com.browsersoft.config.utils.tableinfo.TableField;
import com.browsersoft.config.utils.tableinfo.TableFieldBlob;
import java.io.Serializable;

public class ConfigItemRecord
implements Serializable {
    @TableField
    private long id;
    @TableField
    private ConfigItemRecordType type;
    @TableField
    private String itemId;
    @TableField
    private String originalItemId;
    @TableField
    private String name;
    @TableField
    private String subType;
    @TableField
    @TableFieldBlob
    private String value;
    @TableField
    private String additionalInfo1;
    @TableField
    private String additionalInfo2;
    @TableField
    private String additionalInfo3;
    @TableField
    private String parent;
    @TableField
    private String author;
    @TableField
    private String date;
    private boolean hasContent;
    private boolean broken;
    private String repositoryId;
    private String hash;
    private String copiedItemId;
    private String unchangedItemId;

    public ConfigItemRecord() {
    }

    public ConfigItemRecord(ConfigItemRecordType type) {
        this.type = type;
    }

    public ConfigItemRecord(ConfigItemRecordType type, String id) {
        this.type = type;
        this.itemId = id;
    }

    public ConfigItemRecord(String itemId, String name, ConfigItemRecordType type, String parent, boolean hasContent) {
        this.itemId = itemId;
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.hasContent = hasContent;
    }

    public ConfigItemRecord(String itemId, String name, ConfigItemRecordType type, String parent, boolean hasContent, String repositoryId) {
        this.itemId = itemId;
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.hasContent = hasContent;
        this.repositoryId = repositoryId;
    }

    public boolean isLinked() {
        return this.originalItemId != null && !this.originalItemId.equals("");
    }

    public boolean isExternal() {
        return this.getOriginalItemIdAsObject().isExternal();
    }

    public ConfigItemLink getOriginalItemIdAsObject() {
        return new ConfigItemLink(this.originalItemId);
    }

    public String getUnchangedItemId() {
        if (this.unchangedItemId != null) {
            return this.unchangedItemId;
        }
        return this.itemId;
    }

    public void resetUnchangedItemId() {
        this.unchangedItemId = null;
    }

    public boolean hasItemId() {
        if (this.itemId == null || this.itemId.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(this.itemId);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public ConfigItemRecordType getType() {
        return this.type;
    }

    public void setType(ConfigItemRecordType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String constructUniqueId() {
        return this.repositoryId + "#" + this.itemId;
    }

    public void setItemId(String itemId) {
        if (this.itemId != null && !this.itemId.isEmpty()) {
            this.unchangedItemId = this.itemId;
        }
        this.itemId = itemId;
    }

    public String getParent() {
        if (this.parent == null) {
            this.parent = "";
        }
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ConfigItemRecord cloneRecord() {
        ConfigItemRecord record = new ConfigItemRecord();
        record.type = this.type;
        record.subType = this.subType;
        record.broken = this.broken;
        record.hasContent = this.hasContent;
        record.itemId = this.itemId;
        record.originalItemId = this.originalItemId;
        record.parent = this.parent;
        record.name = this.name;
        record.value = this.value;
        record.additionalInfo1 = this.additionalInfo1;
        record.additionalInfo2 = this.additionalInfo2;
        record.additionalInfo3 = this.additionalInfo3;
        record.repositoryId = this.repositoryId;
        record.author = this.author;
        record.date = this.date;
        record.unchangedItemId = this.unchangedItemId;
        return record;
    }

    public String getAdditionalInfo1() {
        return this.additionalInfo1;
    }

    public void setAdditionalInfo1(String additionalInfo1) {
        this.additionalInfo1 = additionalInfo1;
    }

    public String getAdditionalInfo2() {
        return this.additionalInfo2;
    }

    public void setAdditionalInfo2(String additionalInfo2) {
        this.additionalInfo2 = additionalInfo2;
    }

    public String getAdditionalInfo3() {
        return this.additionalInfo3;
    }

    public void setAdditionalInfo3(String additionalInfo3) {
        this.additionalInfo3 = additionalInfo3;
    }

    public String getOriginalItemId() {
        return this.originalItemId;
    }

    public void setOriginalItemId(String originalItemId) {
        this.originalItemId = originalItemId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String toKey() {
        return this.repositoryId + "-" + this.itemId;
    }

    public String toString() {
        return "ConfigItemRecord{id=" + this.id + ", type=" + (Object)((Object)this.type) + ", itemId='" + this.itemId + '\'' + ", originalItemId='" + this.originalItemId + '\'' + ", name='" + this.name + '\'' + ", subType='" + this.subType + '\'' + ", value='" + this.value + '\'' + ", additionalInfo1='" + this.additionalInfo1 + '\'' + ", additionalInfo2='" + this.additionalInfo2 + '\'' + ", additionalInfo3='" + this.additionalInfo3 + '\'' + ", hasContent=" + this.hasContent + ", parent='" + this.parent + '\'' + ", broken=" + this.broken + ", repositoryId='" + this.repositoryId + '\'' + '}';
    }

    public int hashCode() {
        if (this.itemId != null && !this.itemId.isEmpty()) {
            return this.itemId.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigItemRecord) {
            ConfigItemRecord objRecord = (ConfigItemRecord)obj;
            if (this.itemId != null && objRecord.itemId != null) {
                return this.itemId.equals(objRecord.itemId);
            }
        }
        return super.equals(obj);
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getCopiedItemId() {
        return this.copiedItemId;
    }

    public void setCopiedItemId(String copiedItemId) {
        this.copiedItemId = copiedItemId;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }
}

