/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.release;

import com.browsersoft.config.api.hub.JarRecord;
import com.browsersoft.config.api.release.JarInfo;
import com.browsersoft.config.api.release.ReleaseInfo;
import com.browsersoft.config.api.release.ReleaseVerificationException;
import com.browsersoft.config.utils.JarVerifier;
import com.browsersoft.config.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xml.sax.SAXException;

public class ReleaseVerifier {
    private static final Logger logger = Logger.getLogger(ReleaseVerifier.class.getName());

    public static void verify(List<JarRecord> jars) throws ReleaseVerificationException, SAXException, IOException, CertificateException {
        JarRecord releaseInfoJar = ReleaseVerifier.findReleaseInfoJar(jars);
        if (releaseInfoJar != null) {
            logger.info("Release verification started");
            try {
                ReleaseVerifier.verifyReleaseJars(releaseInfoJar, jars);
            }
            finally {
                logger.info("Release verification finished");
            }
        } else {
            logger.info("Skipping release verification, no release info jar found.");
        }
    }

    private static JarRecord findReleaseInfoJar(List<JarRecord> jars) {
        for (JarRecord jarRecord : jars) {
            if (!jarRecord.getName().equals("hieengine_release.jar")) continue;
            return jarRecord;
        }
        return null;
    }

    private static void verifyReleaseJars(JarRecord releaseInfoJarRecord, List<JarRecord> jars) throws IOException, SAXException, ReleaseVerificationException, CertificateException {
        ReleaseVerifier.verifyReleaseInfoJar(releaseInfoJarRecord);
        String releaseInfoXml = null;
        try (ZipFile releaseInfoZip = new ZipFile(releaseInfoJarRecord.getJarFile());){
            Enumeration<? extends ZipEntry> entries = releaseInfoZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().equals("hieengine_jars.xml")) continue;
                InputStream in = releaseInfoZip.getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    byte[] data = StreamUtils.loadInputStreamToBytes((InputStream)in);
                    releaseInfoXml = new String(data, StandardCharsets.UTF_8);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        if (releaseInfoXml == null || releaseInfoXml.isEmpty()) {
            throw new IOException("Release info file not found or is empty");
        }
        ReleaseInfo releaseInfo = ReleaseInfo.loadFromXml(releaseInfoXml);
        Map<String, JarInfo> jarInfos = releaseInfo.getJars();
        if (jarInfos.size() != jars.size() - 1) {
            throw new ReleaseVerificationException("Release jars count is different then expected. Got '" + jars.size() + "', expected '" + jarInfos.size() + " + 1'.");
        }
        for (JarRecord jarRecord : jars) {
            if (jarRecord.getName().equals("hieengine_release.jar")) continue;
            JarInfo jarInfo = jarInfos.get(jarRecord.getName());
            if (jarInfo == null) {
                if (jarRecord.getName().equals("ojdbc6.jar")) continue;
                throw new ReleaseVerificationException("JarInfo for jar '" + jarRecord.getName() + "' not found!");
            }
            if (jarRecord.getHash().equals(jarInfo.getHash())) continue;
            throw new ReleaseVerificationException("Hashes for jar '" + jarRecord.getName() + "' do not match. " + "Got '" + jarRecord.getHash() + "', expected '" + jarInfo.getHash() + "'.");
        }
    }

    private static void verifyReleaseInfoJar(JarRecord jarRecord) throws CertificateException, IOException {
        X509Certificate certificate = ReleaseVerifier.loadVerificationCertificate();
        JarVerifier jarVerifier = new JarVerifier(certificate);
        jarVerifier.verify(jarRecord.getJarFile());
    }

    private static X509Certificate loadVerificationCertificate() throws CertificateException, IOException {
        ClassLoader classLoader = ReleaseVerifier.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("com/browsersoft/config/api/release/certificate.pem");){
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)fact.generateCertificate(inputStream);
            return x509Certificate;
        }
    }
}

