/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.api.system;

import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemType;
import com.browsersoft.config.api.system.UnixOperatingSystem;
import com.browsersoft.config.api.system.WindowsOperatingSystem;

public class OperatingSystemFactory {
    public static OperatingSystem getOperatingSystem(OperatingSystemType type) throws Exception {
        switch (type) {
            case Windows: {
                return new WindowsOperatingSystem();
            }
            case Unix: {
                return new UnixOperatingSystem();
            }
        }
        throw new Exception("Unknown operating system");
    }

    public static OperatingSystem getCurrentOperatingSystem(String javaBinDir, String oracleLibraryDir, String oracleDriverPath) throws Exception {
        String osName = System.getProperty("os.name");
        String osNameMatch = osName.toLowerCase();
        OperatingSystem system = null;
        if (osNameMatch.contains("linux")) {
            system = new UnixOperatingSystem();
        } else if (osNameMatch.contains("windows")) {
            system = new WindowsOperatingSystem();
        } else if (osNameMatch.contains("solaris") || osNameMatch.contains("sunos")) {
            system = new UnixOperatingSystem();
        } else if (osNameMatch.contains("mac os") || osNameMatch.contains("macos") || osNameMatch.contains("darwin")) {
            system = new UnixOperatingSystem();
        } else {
            throw new Exception("Unsupported operating system");
        }
        system.init(javaBinDir, oracleLibraryDir, oracleDriverPath);
        return system;
    }
}

