/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.node;

import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.EnginesGround;
import com.browsersoft.config.api.node.InstallationSettings;
import com.browsersoft.config.utils.DOMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class InstallationsSettingsManager {
    private static final String SETTINGS_FILENAME = "installations-settings.xml";
    private static Logger log = Logger.getLogger(InstallationsSettingsManager.class.getName());
    private final EnginesGround enginesGround;

    public InstallationsSettingsManager(EnginesGround enginesGround) {
        this.enginesGround = enginesGround;
    }

    public synchronized Map<String, InstallationSettings> getInstallationsSettings() throws IOException, SAXException {
        return this.loadInstallationSettings();
    }

    public synchronized InstallationSettings getInstallationSettings(String name) throws IOException, SAXException {
        Map<String, InstallationSettings> data = this.loadInstallationSettings();
        if (data.containsKey(name)) {
            return data.get(name);
        }
        return new InstallationSettings(name);
    }

    public synchronized void setInstallationSettings(String name, InstallationSettings settings) throws IOException, SAXException {
        boolean found = false;
        List engines = this.enginesGround.getEngines();
        for (EngineGround engine : engines) {
            if (!engine.getName().equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IOException("Engine '" + name + "' not found!");
        }
        settings.setName(name);
        Map<String, InstallationSettings> data = this.loadInstallationSettings();
        data.put(name, settings);
        this.clearUnusedInstallationSettings(data);
        this.saveInstallationSettings(data);
    }

    private void clearUnusedInstallationSettings(Map<String, InstallationSettings> data) {
        List engines = this.enginesGround.getEngines();
        Iterator<Map.Entry<String, InstallationSettings>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, InstallationSettings> entry = it.next();
            boolean found = false;
            for (EngineGround engine : engines) {
                if (!entry.getKey().equals(engine.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
        }
    }

    private Map<String, InstallationSettings> loadInstallationSettings() throws IOException, SAXException {
        HashMap<String, InstallationSettings> data = new HashMap<String, InstallationSettings>();
        File file = new File(this.enginesGround.getRoot(), SETTINGS_FILENAME);
        if (!file.exists() || !file.canRead()) {
            return data;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Element node = DOMUtils.loadFromInputStream((InputStream)in).getDocumentElement();
            List children = DOMUtils.getNodeChilds((Node)node, (String)"installation");
            for (Node child : children) {
                InstallationSettings settings = InstallationSettings.fromXmlNode((Node)child);
                data.put(settings.getName(), settings);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can`t load installations settings", e);
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return data;
    }

    private void saveInstallationSettings(Map<String, InstallationSettings> data) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("<installations>\n");
        for (InstallationSettings item : data.values()) {
            builder.append(item.toXml()).append("\n");
        }
        builder.append("</installations>\n");
        File file = new File(this.enginesGround.getRoot(), SETTINGS_FILENAME);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(builder.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable save installations settings", e);
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

