/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.node;

import com.browsersoft.config.api.AsyncEngineProcess;
import com.browsersoft.config.api.Deployment;
import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.EngineProcess;
import com.browsersoft.config.api.EngineProcessState;
import com.browsersoft.config.api.EngineRun;
import com.browsersoft.config.api.EnginesGround;
import com.browsersoft.config.api.LocalEngineRun;
import com.browsersoft.config.api.Message;
import com.browsersoft.config.api.ReleaseNodeDeploymentInfo;
import com.browsersoft.config.api.TransferableFileStorage;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.api.WorldBindingUtils;
import com.browsersoft.config.api.hub.ConfigDir;
import com.browsersoft.config.api.hub.JarRecord;
import com.browsersoft.config.api.hub.TransferableFileInfo;
import com.browsersoft.config.api.node.InstallationSettings;
import com.browsersoft.config.api.release.ReleaseVerifier;
import com.browsersoft.config.api.system.OperatingSystem;
import com.browsersoft.config.api.system.OperatingSystemFactory;
import com.browsersoft.config.api.system.WindowsOperatingSystem;
import com.browsersoft.config.jgate.SocketGateNode;
import com.browsersoft.config.jgate.annotations.GateMethod;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.external.RuleResolver;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.node.InstallationsSettingsManager;
import com.browsersoft.config.node.ReleaseNodeAccessRuleResolver;
import com.browsersoft.config.node.ReleaseNodeConfiguration;
import com.browsersoft.config.node.audit.DeploymentsAuditorActions;
import com.browsersoft.config.node.audit.DeploymentsAuditorClient;
import com.browsersoft.config.node.audit.DeploymentsAuditorClientImpl;
import com.browsersoft.config.node.audit.DummyDeploymentsAuditorClientImpl;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.FileUtils;
import com.browsersoft.config.utils.Hash;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReleaseNode {
    Logger log = Logger.getLogger(ReleaseNode.class.getName());
    private ReleaseNodeConfiguration configuration;
    private SocketGateNode gateNode;
    private EnginesGround enginesGround;
    private InstallationsSettingsManager installationsSettingsManager;
    private OperatingSystem operatingSystem;
    private DeploymentsAuditorClient auditorClient;
    private boolean updating;

    public ReleaseNode(Node node) throws Exception {
        this.configuration = new ReleaseNodeConfiguration(node);
        this.enginesGround = new EnginesGround(this.configuration.getDeploymentsRoot());
        this.installationsSettingsManager = new InstallationsSettingsManager(this.enginesGround);
        this.operatingSystem = OperatingSystemFactory.getCurrentOperatingSystem((String)this.configuration.getJavaBinDir(), (String)this.configuration.getOracleLibraryDir(), (String)this.configuration.getOracleDriverPath());
        this.auditorClient = this.createAuditorClient(this.configuration);
    }

    public void run() throws Exception {
        this.registerSignalHandler();
        this.enginesAutoStart();
        GateNodeConfiguration gateNodeConfiguration = new GateNodeConfiguration();
        gateNodeConfiguration.addInt("CLIENT_CALLING_TIMEOUT", 10000);
        this.gateNode = new SocketGateNode(gateNodeConfiguration);
        this.gateNode.runAsServer(this.configuration.getGateServerConfiguration());
        this.gateNode.registerService((Object)this, "com.browsersoft.config.api.ReleaseNodeProxy");
        this.gateNode.setRuleResolverToService("", (RuleResolver)new ReleaseNodeAccessRuleResolver(this.configuration));
        System.out.println("************************************");
        System.out.println("Release Node 2.0 started");
        System.out.println("************************************");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Missing required config-path parameter!");
            System.exit(1);
        }
        Element node = DOMUtils.parseFile((String)new File(args[0]).getAbsolutePath()).getDocumentElement();
        if (args.length == 1) {
            new ReleaseNode(node).run();
        } else {
            String cmd = args[1];
            if (cmd.equals("stop-engines")) {
                new ReleaseNode(node).stopEngines();
            } else {
                System.out.println("Unknown command '" + cmd + "'");
                System.exit(1);
            }
        }
    }

    @GateMethod
    public void uploadJar(JarRecord jarRecord, SizedInputStream inputStream) throws Exception {
        this.configuration.getJarStorage().put((TransferableFileInfo)jarRecord, (InputStream)inputStream, null);
    }

    @GateMethod
    public void uploadDir(ConfigDir configDir, SizedInputStream inputStream) throws Exception {
        this.configuration.getDirStorage().put((TransferableFileInfo)configDir, (InputStream)inputStream, null);
    }

    @GateMethod
    public List<JarRecord> getMissingJars(List<JarRecord> records) throws Exception {
        return this.configuration.getJarStorage().filter(records);
    }

    @GateMethod
    public List<ConfigDir> getMissingFolders(List<ConfigDir> folders) throws Exception {
        return this.configuration.getDirStorage().filter(folders);
    }

    @GateMethod
    public void deployDeployment(String deploymentId, Deployment deployment, UserInfo userInfo) throws Exception {
        try {
            EngineGround engineGround = this.enginesGround.getEngineByExternalId(deploymentId);
            LocalEngineRun engineRun = new LocalEngineRun(this.operatingSystem, engineGround);
            AsyncEngineProcess engineProcess = new AsyncEngineProcess((EngineRun)engineRun);
            engineProcess.stopProcess(userInfo);
        }
        catch (Exception engineGround) {
            // empty catch block
        }
        List jars = deployment.getJars();
        for (JarRecord jar : jars) {
            File jarFile = this.configuration.getJarStorage().get((TransferableFileInfo)jar);
            jar.setJarFile(jarFile, false);
        }
        ReleaseVerifier.verify((List)jars);
        EngineGround engineGround = this.enginesGround.newEngine(deploymentId, deployment.getName(), deployment.getReleaseName());
        this.auditorClient.auditDeployment(engineGround, deployment, userInfo);
        WorldBindingUtils.deployDeploymentToFolder((File)engineGround.getFile(), (Deployment)deployment, (TransferableFileStorage)this.configuration.getDirStorage());
        File jarsFolder = new File(engineGround.getFile(), "jars");
        jarsFolder.mkdir();
        this.operatingSystem.createScripts(engineGround.getEngineId(), engineGround.getFile(), engineGround.getFile().getAbsolutePath(), engineGround.getPersistenceRoot().getAbsolutePath(), WorldBindingUtils.deployJarsToFolder((File)jarsFolder, (List)deployment.getJars(), (TransferableFileStorage)this.configuration.getJarStorage()), false, deployment.getJavaOpts());
    }

    @GateMethod
    public void removeDeployment(String engineId, UserInfo userInfo) throws Exception {
        EngineGround engine = this.enginesGround.getEngine(engineId);
        this.auditorClient.auditSimpleDeploymentAction(DeploymentsAuditorActions.ENGINE_REMOVE, engine, userInfo);
        try {
            this.getProcess(engineId).stopProcess(userInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        engine.deleteEngine();
    }

    @GateMethod
    public void startProcess(String engineId, UserInfo userInfo) throws Exception {
        EngineGround engine = this.enginesGround.getEngine(engineId);
        this.auditorClient.auditSimpleDeploymentAction(DeploymentsAuditorActions.ENGINE_START, engine, userInfo);
        this.getProcess(engineId).startProcess(userInfo);
    }

    @GateMethod
    public void killProcess(String engineId, UserInfo userInfo) throws Exception {
        EngineGround engine = this.enginesGround.getEngine(engineId);
        this.auditorClient.auditSimpleDeploymentAction(DeploymentsAuditorActions.ENGINE_KILL, engine, userInfo);
        this.getProcess(engineId).killProcess(userInfo);
    }

    @GateMethod
    public void restartProcess(String engineId, UserInfo userInfo) throws Exception {
        EngineGround engine = this.enginesGround.getEngine(engineId);
        this.auditorClient.auditSimpleDeploymentAction(DeploymentsAuditorActions.ENGINE_RESTART, engine, userInfo);
        this.getProcess(engineId).restartProcess(userInfo);
    }

    @GateMethod
    public void stopProcess(String engineId, UserInfo userInfo) throws Exception {
        EngineGround engine = this.enginesGround.getEngine(engineId);
        this.auditorClient.auditSimpleDeploymentAction(DeploymentsAuditorActions.ENGINE_STOP, engine, userInfo);
        this.getProcess(engineId).stopProcess(userInfo);
    }

    @GateMethod
    public void clearDeployments(UserInfo userInfo) throws Exception {
        this.auditorClient.auditSimpleDeploymentAction(DeploymentsAuditorActions.ENGINES_CLEAR, null, userInfo);
        List engines = this.enginesGround.getEngines();
        for (EngineGround engineGround : engines) {
            LocalEngineRun localEngineRun = new LocalEngineRun(this.operatingSystem, engineGround);
            if (localEngineRun.getState() != EngineProcessState.STOPPED) {
                localEngineRun.stopEngine(userInfo);
            }
            engineGround.deleteEngine();
        }
    }

    @GateMethod
    public void setAddHocPassword(String adHocPassword) throws Exception {
        File file = new File(this.configuration.getRoot(), "password.txt");
        FileUtils.saveBytesToFile((File)file, (byte[])adHocPassword.getBytes("UTF-8"));
    }

    @GateMethod
    public String getAddHocPassword() throws Exception {
        File file = new File(this.configuration.getRoot(), "password.txt");
        if (file.exists()) {
            return FileUtils.loadFileToString((File)file, (String)"UTF-8").trim();
        }
        return "";
    }

    @GateMethod
    public String getVersion() throws Exception {
        return "31";
    }

    @GateMethod
    public void startUpdateVersion() throws Exception {
        if (this.updating) {
            throw new Exception("Update in progress");
        }
        FileUtils.deleteDir((File)this.configuration.getUpdatePath());
        this.configuration.getUpdatePath().mkdir();
        File libsDir = new File(this.configuration.getUpdatePath(), "libs");
        libsDir.mkdir();
    }

    @GateMethod
    public void skipUpdateVersion() throws Exception {
        this.updating = false;
        FileUtils.deleteDir((File)this.configuration.getUpdatePath());
        this.configuration.getUpdatePath().mkdir();
    }

    @GateMethod
    public void stopUpdateVersion(Map<String, String> files) throws Exception {
        try {
            for (Map.Entry<String, String> entry : files.entrySet()) {
                String path = entry.getKey();
                String hash = entry.getValue();
                File file = new File(this.configuration.getUpdatePath(), path);
                if (!file.exists()) {
                    throw new FileNotFoundException("Update file '" + path + "' not found!");
                }
                String fileHash = Hash.toHex((byte[])Hash.forFile((File)file));
                if (fileHash.equals(hash)) continue;
                throw new Exception("Update file hash '" + fileHash + "' differs from expected hash '" + hash + "'");
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Skipping update, error occurred during pre-check", e);
            this.skipUpdateVersion();
            throw e;
        }
        OperatingSystem os = OperatingSystemFactory.getCurrentOperatingSystem(null, null, null);
        if (!(os instanceof WindowsOperatingSystem)) {
            os.runScriptNatively(this.configuration.getNodeRoot(), "redeploy.sh");
        }
        System.exit(0);
    }

    @GateMethod
    public void executeEngineCommand(String engineId, String command) throws Exception {
        this.getProcess(engineId).executeEngineCommand(command);
    }

    @GateMethod
    public void uploadUpdateFile(String path, String hash, SizedInputStream inputStream) throws Exception {
        boolean res;
        this.log.info("Receiving update file '" + path + "' [" + hash + "] of size " + inputStream.getSize());
        Path updatePath = this.configuration.getUpdatePath().toPath().normalize().toAbsolutePath();
        File destFile = new File(this.configuration.getUpdatePath(), path);
        Path destPath = destFile.toPath().normalize().toAbsolutePath();
        if (!destPath.startsWith(updatePath)) {
            String msg = "Destination path '" + path + "' is outside allowed update path!";
            this.log.warning(msg);
            throw new Exception(msg);
        }
        File destDir = destFile.getParentFile();
        if (!destDir.exists() && !(res = destDir.mkdirs())) {
            String msg = "Unable to create directory '" + destDir.getAbsolutePath() + "'";
            this.log.warning(msg);
            throw new Exception(msg);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(destFile);
        Object msg = null;
        try {
            GateUtils.inputStreamToOutputStreamWithHandler((InputStream)inputStream, (OutputStream)fileOutputStream, null, (long)inputStream.getSize(), (int)1024);
            String fileHash = Hash.toHex((byte[])Hash.forFile((File)destFile));
            if (!fileHash.equals(hash)) {
                String msg2 = "Received file hash is different from stored file hash!";
                this.log.warning(msg2);
                throw new Exception(msg2);
            }
        }
        catch (Throwable throwable) {
            msg = throwable;
            throw throwable;
        }
        finally {
            if (fileOutputStream != null) {
                if (msg != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)msg).addSuppressed(throwable);
                    }
                } else {
                    fileOutputStream.close();
                }
            }
        }
        if (path.endsWith(".sh") && !(res = destFile.setExecutable(true))) {
            msg = "Unable to set file '" + path + "' as executable";
            this.log.warning((String)msg);
            throw new Exception((String)msg);
        }
        this.log.info("Update file '" + destFile + "' successfully stored");
    }

    @GateMethod
    public long getJarSize(String name) throws Exception {
        File libsDir = new File(this.configuration.getUpdatePath(), "libs");
        File file = new File(libsDir, name);
        if (!file.exists()) {
            return 0L;
        }
        return file.length();
    }

    @GateMethod
    public List<ReleaseNodeDeploymentInfo> getDeployments() throws Exception {
        List engines = this.enginesGround.getEngines();
        ArrayList<ReleaseNodeDeploymentInfo> ret = new ArrayList<ReleaseNodeDeploymentInfo>();
        for (EngineGround engineGround : engines) {
            ReleaseNodeDeploymentInfo deploymentInfo = new ReleaseNodeDeploymentInfo();
            LocalEngineRun localEngineRun = new LocalEngineRun(this.operatingSystem, engineGround);
            deploymentInfo.setState(localEngineRun.getState());
            deploymentInfo.setName(engineGround.getName());
            deploymentInfo.setId(engineGround.getEngineId());
            deploymentInfo.setReleaseName(engineGround.getReleaseName());
            ret.add(deploymentInfo);
        }
        return ret;
    }

    @GateMethod
    public String getConsole(String id) throws Exception {
        return this.getProcess(id).getConsole();
    }

    @GateMethod
    public List<Message> readConsole(String id, String lastMessageId) throws Exception {
        return this.getProcess(id).getConsole(lastMessageId);
    }

    @GateMethod
    public EngineProcessState getState(String engineId) throws Exception {
        return this.getRun(engineId).getState();
    }

    @GateMethod
    public byte[] handleStepRequest(String boxId, byte[] o, String engineId) throws Exception {
        EngineRun run = this.getRun(engineId);
        if (run.getState() != EngineProcessState.STARTED) {
            throw new Exception("Process not running");
        }
        return run.handleStepRequest(boxId, o);
    }

    @GateMethod
    public byte[] readFile(String engineId, String name) throws Exception {
        EngineRun run = this.getRun(engineId);
        return run.readFile(name);
    }

    @GateMethod
    public InstallationSettings getInstallationSettings(String name) throws Exception {
        return this.installationsSettingsManager.getInstallationSettings(name);
    }

    @GateMethod
    public void setInstallationSettings(String name, InstallationSettings installationSettings) throws Exception {
        this.installationsSettingsManager.setInstallationSettings(name, installationSettings);
    }

    private EngineProcess getProcess(String id) throws Exception {
        return new AsyncEngineProcess(this.getRun(id));
    }

    private EngineRun getRun(String id) throws Exception {
        return new LocalEngineRun(this.operatingSystem, this.enginesGround.getEngine(id));
    }

    private void enginesAutoStart() {
        try {
            Map<String, InstallationSettings> settingsMap = this.installationsSettingsManager.getInstallationsSettings();
            List engines = this.enginesGround.getEngines();
            for (EngineGround engine : engines) {
                EngineProcess engineProcess;
                EngineProcessState state;
                InstallationSettings engineSettings;
                if (!settingsMap.containsKey(engine.getName()) || !(engineSettings = settingsMap.get(engine.getName())).getAutoStart() || (state = (engineProcess = this.getProcess(engine.getEngineId())).getState()) == EngineProcessState.STARTED || state == EngineProcessState.STARTING) continue;
                engineProcess.startProcess(null);
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Auto start error", e);
        }
    }

    public void stopEngines() throws Exception {
        EngineProcess engineProcess;
        List engines = this.enginesGround.getEngines();
        for (EngineGround engine : engines) {
            System.out.println("Stopping engine '" + engine.getName() + "'");
            EngineProcess engineProcess2 = this.getProcess(engine.getEngineId());
            engineProcess2.stopProcess(null);
        }
        long start = System.currentTimeMillis();
        while (!engines.isEmpty() && start > System.currentTimeMillis() - 15000L) {
            Thread.sleep(500L);
            Iterator iterator = engines.iterator();
            while (iterator.hasNext()) {
                EngineGround engine = (EngineGround)iterator.next();
                engineProcess = this.getProcess(engine.getEngineId());
                if (!engineProcess.getState().equals((Object)EngineProcessState.STOPPED)) continue;
                System.out.println("Engine '" + engine.getName() + "' stopped");
                iterator.remove();
            }
        }
        for (EngineGround engine : engines) {
            System.out.println("Killing engine '" + engine.getName() + "'");
            engineProcess = this.getProcess(engine.getEngineId());
            engineProcess.killProcess(null);
        }
        System.out.println("\nFinished.");
    }

    private DeploymentsAuditorClient createAuditorClient(ReleaseNodeConfiguration configuration) {
        String url = configuration.getAuditorUrl();
        if (url != null && !url.isEmpty()) {
            return new DeploymentsAuditorClientImpl(url, configuration.getAuditorToken(), configuration.getAuditorNodeId(), configuration.getAuditorTimeout(), configuration.isAuditorSkipCertificateCheck());
        }
        return new DummyDeploymentsAuditorClientImpl();
    }

    private void registerSignalHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ReleaseNode.this.gateNode.closeAllReceivers();
            }
        });
    }
}

