/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.node.audit;

import com.browsersoft.config.api.Deployment;
import com.browsersoft.config.api.EngineGround;
import com.browsersoft.config.api.UserInfo;
import com.browsersoft.config.node.audit.DeploymentsAuditorActions;
import com.browsersoft.config.node.audit.DeploymentsAuditorClient;
import com.browsersoft.config.utils.DOMUtils;
import com.browsersoft.config.utils.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class DeploymentsAuditorClientImpl
implements DeploymentsAuditorClient {
    private static final Logger logger = Logger.getLogger(DeploymentsAuditorClientImpl.class.getName());
    private final String url;
    private final String token;
    private final String nodeId;
    private final int timeout;
    private final boolean skipCertificateCheck;
    private SSLSocketFactory _sslSocketFactory;

    public DeploymentsAuditorClientImpl(String url, String token, String nodeId, int timeout, boolean skipCertificateCheck) {
        this.url = url;
        this.token = token;
        this.nodeId = nodeId;
        this.timeout = timeout;
        this.skipCertificateCheck = skipCertificateCheck;
    }

    @Override
    public void auditSimpleDeploymentAction(DeploymentsAuditorActions action, EngineGround engine, UserInfo userInfo) {
        try {
            String auditXml = this.assembleAuditEventXml(action, engine, userInfo != null ? userInfo : new UserInfo(), null);
            this.sendAudit(auditXml);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while preparing audit event: ", e);
        }
    }

    @Override
    public void auditDeployment(EngineGround engine, Deployment deployment, UserInfo userInfo) {
        try {
            String deploymentDetail = this.assembleDeploymentDetailXml(deployment);
            String auditXml = this.assembleAuditEventXml(DeploymentsAuditorActions.ENGINE_DEPLOY, engine, userInfo != null ? userInfo : new UserInfo(), deploymentDetail);
            this.sendAudit(auditXml);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while preparing audit event: ", e);
        }
    }

    private String assembleAuditEventXml(DeploymentsAuditorActions action, EngineGround engine, UserInfo userInfo, String extraData) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("<event>\n");
        builder.append("  <nodeId>").append(this.nodeId).append("</nodeId>\n");
        builder.append("  <timestamp>").append(System.currentTimeMillis()).append("</timestamp>\n");
        builder.append("  <action>").append(action.name()).append("</action>\n");
        this.appendWithIndentation(builder, userInfo.getXml(), 2);
        builder.append("\n");
        if (engine != null) {
            builder.append("  <engine>\n");
            builder.append("    <engineId>").append(engine.getEngineId()).append("</engineId>\n");
            builder.append("    <externalId>").append(engine.getExternalId()).append("</externalId>\n");
            builder.append("    <engineName>").append(DOMUtils.stringToEntity((String)engine.getName())).append("</engineName>\n");
            builder.append("    <releaseName>").append(engine.getReleaseName()).append("</releaseName>\n");
            builder.append("  </engine>\n");
        }
        if (extraData != null) {
            this.appendWithIndentation(builder, extraData, 2);
            builder.append("\n");
        }
        builder.append("</event>");
        return builder.toString();
    }

    private String assembleDeploymentDetailXml(Deployment deployment) throws IOException {
        String javaOpts = deployment.getJavaOpts();
        String config = deployment.getConfig();
        String profile = deployment.getProfile();
        String javaOptsB64 = "";
        if (javaOpts != null && !javaOpts.isEmpty()) {
            byte[] javaOptsBytes = javaOpts.getBytes(StandardCharsets.UTF_8);
            byte[] javaOptsZip = this.zip(javaOptsBytes);
            javaOptsB64 = Base64.getEncoder().encodeToString(javaOptsZip);
        }
        String configB64 = "";
        if (config != null && !config.isEmpty()) {
            byte[] configBytes = config.getBytes(StandardCharsets.UTF_8);
            byte[] configZip = this.zip(configBytes);
            configB64 = Base64.getEncoder().encodeToString(configZip);
        }
        String profileB64 = "";
        if (profile != null && !profile.isEmpty()) {
            byte[] profileBytes = profile.getBytes(StandardCharsets.UTF_8);
            byte[] profileZip = this.zip(profileBytes);
            profileB64 = Base64.getEncoder().encodeToString(profileZip);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<deployment>\n");
        builder.append("  <javaOpts>").append(javaOptsB64).append("</javaOpts>\n");
        builder.append("  <config>").append(configB64).append("</config>\n");
        builder.append("  <profile>").append(profileB64).append("</profile>\n");
        builder.append("</deployment>");
        return builder.toString();
    }

    private void sendAudit(String auditXml) {
        Thread thread = new Thread(() -> {
            try {
                byte[] data = auditXml.getBytes(StandardCharsets.UTF_8);
                HttpURLConnection c = (HttpURLConnection)new URL(this.url).openConnection();
                if (c instanceof HttpsURLConnection && this.skipCertificateCheck) {
                    ((HttpsURLConnection)c).setSSLSocketFactory(this.createSSLSocketFactory());
                    ((HttpsURLConnection)c).setHostnameVerifier((s, sslSession) -> true);
                }
                c.setConnectTimeout(this.timeout);
                c.setRequestMethod("POST");
                c.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
                if (this.token != null && !this.token.isEmpty()) {
                    c.setRequestProperty("X-Auditor-Token", this.token);
                }
                c.setFixedLengthStreamingMode(data.length);
                c.setDoOutput(true);
                try (OutputStream os = c.getOutputStream();){
                    os.write(data);
                }
                int responseCode = c.getResponseCode();
                if (responseCode != 200) {
                    String responseMessage = c.getResponseMessage();
                    logger.warning("Received unexpected response to audit request: " + responseCode + " - " + responseMessage);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while sending audit event: ", e);
            }
        });
        thread.start();
    }

    private SSLSocketFactory createSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        if (this._sslSocketFactory == null) {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            this._sslSocketFactory = context.getSocketFactory();
        }
        return this._sslSocketFactory;
    }

    private void appendWithIndentation(StringBuilder builder, String data, int indentation) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(data));
        boolean first = true;
        while ((line = reader.readLine()) != null) {
            if (!first) {
                builder.append("\n");
            }
            first = false;
            builder.append(StringUtils.repeat((String)" ", (int)indentation));
            builder.append(line);
        }
    }

    private byte[] zip(byte[] data) throws IOException {
        byte[] buffer = new byte[2048];
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(byteArrayOutputStream);){
            int num;
            while ((num = in.read(buffer)) != -1) {
                out.write(buffer, 0, num);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

