/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarVerifier {
    private final X509Certificate certificate;

    public JarVerifier(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void verify(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            if (this.certificate == null) {
                throw new SecurityException("Provider certificate is invalid");
            }
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            Manifest man = jarFile.getManifest();
            if (man == null) {
                throw new SecurityException("The provider is not signed");
            }
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int n;
                JarEntry je = entries.nextElement();
                if (je.isDirectory()) continue;
                entriesVec.addElement(je);
                InputStream is = jarFile.getInputStream(je);
                while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                }
                is.close();
            }
            Enumeration e = entriesVec.elements();
            while (e.hasMoreElements()) {
                X509Certificate[] certChain;
                JarEntry je = (JarEntry)e.nextElement();
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    if (je.getName().startsWith("META-INF")) continue;
                    throw new SecurityException("The provider has unsigned class files.");
                }
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = JarVerifier.getAChain(certs, startIndex)) != null) {
                    if (certChain[0].equals(this.certificate)) {
                        signedAsExpected = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                throw new SecurityException("The provider is not signed by a trusted signer");
            }
        }
    }

    private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
        int i;
        if (startIndex > certs.length - 1) {
            return null;
        }
        for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
        }
        int certChainSize = i - startIndex + 1;
        X509Certificate[] ret = new X509Certificate[certChainSize];
        for (int j = 0; j < certChainSize; ++j) {
            ret[j] = (X509Certificate)certs[startIndex + j];
        }
        return ret;
    }
}

