/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class Mailer {
    private final Settings settings;
    private Session session;
    private MimeBodyPart body = new MimeBodyPart();
    private List<MimeBodyPart> attachments = new ArrayList<MimeBodyPart>();
    private MimeMessage message;

    public Mailer(Settings settings) throws MessagingException {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.settings = settings;
        this.session = Session.getDefaultInstance((Properties)this.buildProperties(), (Authenticator)this.buildAuthenticator());
        this.message = this.buildMessage();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setFrom(String from) throws MessagingException {
        this.message.setFrom((Address)new InternetAddress(from));
    }

    public Address[] getFrom() throws MessagingException {
        return this.message.getFrom();
    }

    public void setTo(String to) throws MessagingException {
        this.message.setRecipients(Message.RecipientType.TO, to);
    }

    public Address[] getTo() throws MessagingException {
        return this.message.getRecipients(Message.RecipientType.TO);
    }

    public void setReplyTo(String replyTo) throws MessagingException {
        this.message.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(replyTo)});
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.message.getReplyTo();
    }

    public void setSubject(String subject) throws MessagingException {
        this.message.setSubject(subject);
    }

    public String getSubject() throws MessagingException {
        return this.message.getSubject();
    }

    public void setBody(String body) throws MessagingException {
        this.setBody(body, false);
    }

    public void setBody(String body, boolean isHtml) throws MessagingException {
        String type = isHtml ? "text/html" : "text/plain";
        this.body.setContent((Object)body, type + "; charset=utf-8");
    }

    public void addAttachment(String filename, String mimeType, byte[] data) throws MessagingException {
        ByteArrayDataSource source = new ByteArrayDataSource(data, mimeType);
        MimeBodyPart attachment = new MimeBodyPart();
        attachment.setDataHandler(new DataHandler((DataSource)source));
        attachment.setFileName(filename);
        this.attachments.add(attachment);
    }

    private Properties buildProperties() {
        Properties props = new Properties();
        if (this.settings.smtpTransportType != null) {
            if (this.settings.smtpTransportType.equals((Object)TransportType.SSL)) {
                props.put("mail.smtp.ssl.enable", "true");
                props.put("mail.smtp.port", "465");
            } else if (this.settings.smtpTransportType.equals((Object)TransportType.STARTTLS)) {
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.port", "587");
            }
        }
        if (this.settings.smtpHostname != null && !this.settings.smtpHostname.isEmpty()) {
            props.put("mail.smtp.host", this.settings.smtpHostname);
        }
        if (this.settings.smtpPort != null && !this.settings.smtpPort.isEmpty()) {
            props.put("mail.smtp.port", this.settings.smtpPort);
        }
        if (this.settings.smtpUsername != null && !this.settings.smtpUsername.isEmpty()) {
            props.put("mail.smtp.auth", "true");
        }
        return props;
    }

    private Authenticator buildAuthenticator() {
        if (this.settings.smtpUsername == null || this.settings.smtpUsername.isEmpty()) {
            return null;
        }
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(Mailer.this.settings.smtpUsername, Mailer.this.settings.smtpPassword);
            }
        };
    }

    private MimeMessage buildMessage() throws MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        if (this.settings.from != null && !this.settings.from.isEmpty()) {
            message.setFrom((Address)new InternetAddress(this.settings.from));
        }
        if (this.settings.to != null && !this.settings.to.isEmpty()) {
            message.setRecipients(MimeMessage.RecipientType.TO, this.settings.to);
        }
        if (this.settings.replyTo != null && !this.settings.replyTo.isEmpty()) {
            message.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(this.settings.replyTo)});
        }
        if (this.settings.subject != null && !this.settings.subject.isEmpty()) {
            message.setSubject(this.settings.subject);
        }
        return message;
    }

    public void sendMail() throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)this.body);
        for (MimeBodyPart attachment : this.attachments) {
            multipart.addBodyPart((BodyPart)attachment);
        }
        this.message.setContent((Multipart)multipart);
        this.message.setSentDate(new Date());
        this.message.saveChanges();
        Transport transport = this.session.getTransport("smtp");
        transport.connect();
        transport.sendMessage((Message)this.message, this.message.getAllRecipients());
        transport.close();
    }

    public static enum TransportType {
        NORMAL,
        SSL,
        STARTTLS;


        public static TransportType fromString(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            return TransportType.valueOf(value.toUpperCase());
        }
    }

    public static class Settings {
        private TransportType smtpTransportType;
        private String smtpHostname;
        private String smtpPort;
        private String smtpUsername;
        private String smtpPassword;
        private String from;
        private String to;
        private String replyTo;
        private String subject;

        public void setSmtpTransportType(TransportType smtpTransportType) {
            this.smtpTransportType = smtpTransportType;
        }

        public TransportType getSmtpTransportType() {
            return this.smtpTransportType;
        }

        public void setSmtpHostname(String hostname) {
            this.smtpHostname = hostname;
        }

        public String getSmtpHostname() {
            return this.smtpHostname;
        }

        public void setSmtpPort(String port) {
            this.smtpPort = port;
        }

        public String getSmtpPort() {
            return this.smtpPort;
        }

        public void setSmtpUsername(String username) {
            this.smtpUsername = username;
        }

        public String getSmtpUsername() {
            return this.smtpUsername;
        }

        public void setSmtpPassword(String password) {
            this.smtpPassword = password;
        }

        public String getSmtpPassword() {
            return this.smtpPassword;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getFrom() {
            return this.from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getTo() {
            return this.to;
        }

        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }
    }
}

