/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isDefined(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String toString(Map<?, ?> map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Object key : map.keySet()) {
            String v;
            String k;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            try {
                k = key.toString();
            }
            catch (Exception e) {
                k = "!EXCEPTION!";
            }
            try {
                Object value = map.get(key);
                v = value != null ? value.toString() : "";
            }
            catch (Exception e) {
                v = "!EXCEPTION!";
            }
            sb.append(k).append("='").append(v).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public static String nvl(String str) {
        return str != null ? str : "";
    }

    public static byte[] getUTF8BytesIfPossible(String xml) {
        try {
            return xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return xml.getBytes();
        }
    }

    public static String toUTF8StringIfPossible(ByteArrayOutputStream bout) {
        try {
            return bout.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return bout.toString();
        }
    }

    public static String listToString(Collection<String> list, String separator) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String listToString(List<Object> list, String separator) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String arrayToString(String[] list, String separator) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            sb.append(list[i]);
            if (i == list.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String repeat(String s, int num) {
        if (s == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < num; ++i) {
            ret = ret + s;
        }
        return ret;
    }
}

