/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils;

import com.browsersoft.config.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static byte[] zipDirWithDiffRoot(String dir, String rootName) throws Exception {
        File dirObj = new File(dir);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(byteArrayOutputStream);
        ZipUtil.addDir(dirObj, rootName, out);
        out.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] zipDir(String dir) throws Exception {
        File dirObj = new File(dir);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(byteArrayOutputStream);
        ZipUtil.addDir(dirObj, "", out);
        out.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void zipDir(String dir, OutputStream outputStream) throws Exception {
        File dirObj = new File(dir);
        ZipOutputStream out = new ZipOutputStream(outputStream);
        ZipUtil.addDir(dirObj, dirObj.getName(), out);
        out.close();
    }

    static void addDir(File dirObj, String relative, ZipOutputStream out) throws IOException {
        File[] files = dirObj.listFiles();
        byte[] tmpBuf = new byte[1024];
        String prefix = "";
        if (!relative.equals("")) {
            prefix = relative + "/";
        }
        for (int i = 0; i < files.length; ++i) {
            int len;
            if (files[i].isDirectory()) {
                ZipEntry zipEntry = new ZipEntry(prefix + files[i].getName() + "/");
                zipEntry.setTime(files[i].lastModified());
                out.putNextEntry(zipEntry);
                ZipUtil.addDir(files[i], prefix + files[i].getName(), out);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i].getAbsolutePath());
            ZipEntry zipEntry = new ZipEntry(prefix + files[i].getName());
            zipEntry.setTime(files[i].lastModified());
            out.putNextEntry(zipEntry);
            while ((len = in.read(tmpBuf)) > 0) {
                out.write(tmpBuf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }

    public static void unpackZip(byte[] bytes, File destination) throws IOException {
        ZipUtil.unpackZip(new ByteArrayInputStream(bytes), destination, false);
    }

    public static void unpackZip(InputStream inputStream, File destination, boolean makeParents) throws IOException {
        ZipInputStream zin = new ZipInputStream(inputStream);
        ZipEntry ze = null;
        while ((ze = zin.getNextEntry()) != null) {
            int r;
            File file = new File(destination, ze.getName());
            if (ze.isDirectory()) {
                file.mkdir();
                zin.closeEntry();
                continue;
            }
            if (makeParents) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fout = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            while ((r = zin.read(buf)) != -1) {
                fout.write(buf, 0, r);
            }
            zin.closeEntry();
            fout.close();
        }
        zin.close();
    }

    public static void unpackZip(File file, File destication) throws IOException {
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            File outFile = new File(destication, entry.getName());
            outFile.getParentFile().mkdirs();
            ZipUtil.inputStreamToOutputStream(zip.getInputStream(entry), new FileOutputStream(outFile), 2000);
        }
    }

    public static List<File> unpackZipWithReturnEntries(File file, File destication) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            File outFile = new File(destication, entry.getName());
            files.add(outFile);
            outFile.getParentFile().mkdirs();
            ZipUtil.inputStreamToOutputStream(zip.getInputStream(entry), new FileOutputStream(outFile), 2000);
        }
        return files;
    }

    public static byte[] unpackZipEntry(InputStream in, String entryName) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(in);
        while ((entry = zip.getNextEntry()) != null && !entry.getName().equals(entryName)) {
        }
        if (entry == null) {
            return null;
        }
        return StreamUtils.loadInputStreamToBytes(zip);
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.close();
        inputStream.close();
    }

    public static InputStream openInputStream(ZipEntry zipEntry, InputStream inputStream) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals(zipEntry.getName())) continue;
            return zis;
        }
        return null;
    }

    public static List<ZipEntry> getZipEntriesInEntry(ZipFile zipFile, String path) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtil.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtil.getNumberOfSlashs(path) != ZipUtil.getNumberOfSlashs(name) || path.equals(name) || !name.startsWith(path)) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static List<ZipEntry> getZipEntriesInEntryDeep(ZipFile zipFile, ZipEntry entry) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        zipEntries.add(entry);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = ZipUtil.getNameWithoutSlash(zipEntry.getName());
            if (ZipUtil.getNumberOfSlashs(entry.getName()) > ZipUtil.getNumberOfSlashs(name) || entry.getName().equals(name) || !name.startsWith(entry.getName())) continue;
            zipEntries.add(zipEntry);
        }
        return zipEntries;
    }

    public static int getNumberOfSlashs(String s) {
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '/') continue;
            ++counter;
        }
        return counter;
    }

    public static String getNameWithoutSlash(String name) {
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static void zipFolder(File srcFolder, File destZipFile) throws Exception {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
        for (File file : srcFolder.listFiles()) {
            ZipUtil.addFileToZip("", file.getAbsolutePath(), zip);
        }
        zip.flush();
        zip.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File file = new File(srcFile);
        if (file.isDirectory()) {
            ZipUtil.addFolderToZip(path, srcFile, zip);
        } else {
            String entryName = file.getName();
            if (path != null && !path.isEmpty()) {
                entryName = path + "/" + entryName;
            }
            FileInputStream in = null;
            try {
                int len;
                in = new FileInputStream(srcFile);
                zip.putNextEntry(new ZipEntry(entryName));
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        for (String fileName : folder.list()) {
            String entryName = folder.getName();
            if (path != null && !path.isEmpty()) {
                entryName = path + "/" + entryName;
            }
            ZipUtil.addFileToZip(entryName, srcFolder + "/" + fileName, zip);
        }
    }
}

