/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.db;

import com.browsersoft.config.utils.DOMUtils;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import org.w3c.dom.Node;

public class DbConnectionConfiguration {
    private String databaseDriver;
    private String databaseConnection;
    private String databaseUser;
    private String databasePassword;
    private int databaseInitPoolSize;
    private int databaseAcquireIncrement;
    private int databaseAcquireIdleTestPeriod;
    private int databaseMaxIdleTime;
    private int databaseMaxIdleTimeExcessConnections;
    private int databaseMaxConnectionAge;
    private int databaseMaxSize;
    private int databaseMinSize;
    private int databaseMaxStatements;
    private String databasePreferredTestQuery;
    private int databaseUnreturnedConnectionTimeout;

    public DbConnectionConfiguration(Node node) {
        this.databaseDriver = DOMUtils.getParameter(node, "driver");
        this.databaseConnection = DOMUtils.getParameter(node, "connection");
        this.databaseUser = DOMUtils.getParameter(node, "user");
        this.databasePassword = DOMUtils.getParameter(node, "password");
        this.databaseInitPoolSize = DOMUtils.getIntParameter(node, "databaseInitPoolSize", 10);
        this.databaseAcquireIncrement = DOMUtils.getIntParameter(node, "databaseAcquireIncrement", 3);
        this.databaseAcquireIdleTestPeriod = DOMUtils.getIntParameter(node, "databaseAcquireIdleTestPeriod", 0);
        this.databaseMaxIdleTime = DOMUtils.getIntParameter(node, "databaseMaxIdleTime", 0);
        this.databaseMaxIdleTimeExcessConnections = DOMUtils.getIntParameter(node, "databaseMaxIdleTimeExcessConnections", 0);
        this.databaseMaxConnectionAge = DOMUtils.getIntParameter(node, "databaseMaxConnectionAge", 0);
        this.databaseMaxSize = DOMUtils.getIntParameter(node, "databaseMaxSize", 10);
        this.databaseMinSize = DOMUtils.getIntParameter(node, "databaseMinSize", 3);
        this.databaseMaxStatements = DOMUtils.getIntParameter(node, "databaseMaxStatements", 0);
        this.databasePreferredTestQuery = DOMUtils.getParameter(node, "databasePreferredTestQuery");
        this.databaseUnreturnedConnectionTimeout = DOMUtils.getIntParameter(node, "databaseUnreturnedConnectionTimeout", 0);
    }

    public ComboPooledDataSource createDataSource() throws PropertyVetoException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(this.databaseDriver);
        dataSource.setJdbcUrl(this.databaseConnection);
        dataSource.setUser(this.databaseUser);
        dataSource.setPassword(this.databasePassword);
        dataSource.setInitialPoolSize(this.databaseInitPoolSize);
        dataSource.setAcquireIncrement(this.databaseAcquireIncrement);
        dataSource.setIdleConnectionTestPeriod(this.databaseAcquireIdleTestPeriod);
        dataSource.setMaxIdleTime(this.databaseMaxIdleTime);
        dataSource.setMaxIdleTimeExcessConnections(this.databaseMaxIdleTimeExcessConnections);
        dataSource.setMaxConnectionAge(this.databaseMaxConnectionAge);
        dataSource.setMaxPoolSize(this.databaseMaxSize);
        dataSource.setMinPoolSize(this.databaseMinSize);
        dataSource.setMaxStatements(this.databaseMaxStatements);
        dataSource.setPreferredTestQuery(this.databasePreferredTestQuery);
        dataSource.setDebugUnreturnedConnectionStackTraces(true);
        dataSource.setUnreturnedConnectionTimeout(this.databaseUnreturnedConnectionTimeout);
        return dataSource;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public String getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void setDatabaseConnection(String databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public int getDatabaseInitPoolSize() {
        return this.databaseInitPoolSize;
    }

    public void setDatabaseInitPoolSize(int databaseInitPoolSize) {
        this.databaseInitPoolSize = databaseInitPoolSize;
    }

    public int getDatabaseAcquireIncrement() {
        return this.databaseAcquireIncrement;
    }

    public void setDatabaseAcquireIncrement(int databaseAcquireIncrement) {
        this.databaseAcquireIncrement = databaseAcquireIncrement;
    }

    public int getDatabaseAcquireIdleTestPeriod() {
        return this.databaseAcquireIdleTestPeriod;
    }

    public void setDatabaseAcquireIdleTestPeriod(int databaseAcquireIdleTestPeriod) {
        this.databaseAcquireIdleTestPeriod = databaseAcquireIdleTestPeriod;
    }

    public int getDatabaseMaxIdleTime() {
        return this.databaseMaxIdleTime;
    }

    public void setDatabaseMaxIdleTime(int databaseMaxIdleTime) {
        this.databaseMaxIdleTime = databaseMaxIdleTime;
    }

    public int getDatabaseMaxIdleTimeExcessConnections() {
        return this.databaseMaxIdleTimeExcessConnections;
    }

    public void setDatabaseMaxIdleTimeExcessConnections(int databaseMaxIdleTimeExcessConnections) {
        this.databaseMaxIdleTimeExcessConnections = databaseMaxIdleTimeExcessConnections;
    }

    public int getDatabaseMaxConnectionAge() {
        return this.databaseMaxConnectionAge;
    }

    public void setDatabaseMaxConnectionAge(int databaseMaxConnectionAge) {
        this.databaseMaxConnectionAge = databaseMaxConnectionAge;
    }

    public int getDatabaseMaxSize() {
        return this.databaseMaxSize;
    }

    public void setDatabaseMaxSize(int databaseMaxSize) {
        this.databaseMaxSize = databaseMaxSize;
    }

    public int getDatabaseMinSize() {
        return this.databaseMinSize;
    }

    public void setDatabaseMinSize(int databaseMinSize) {
        this.databaseMinSize = databaseMinSize;
    }

    public int getDatabaseMaxStatements() {
        return this.databaseMaxStatements;
    }

    public void setDatabaseMaxStatements(int databaseMaxStatements) {
        this.databaseMaxStatements = databaseMaxStatements;
    }

    public String getDatabasePreferredTestQuery() {
        return this.databasePreferredTestQuery;
    }

    public void setDatabasePreferredTestQuery(String databasePreferredTestQuery) {
        this.databasePreferredTestQuery = databasePreferredTestQuery;
    }

    public int getDatabaseUnreturnedConnectionTimeout() {
        return this.databaseUnreturnedConnectionTimeout;
    }

    public void setDatabaseUnreturnedConnectionTimeout(int databaseUnreturnedConnectionTimeout) {
        this.databaseUnreturnedConnectionTimeout = databaseUnreturnedConnectionTimeout;
    }
}

