/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.streams;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class SizedInputStream
extends InputStream {
    private final InputStream parent;
    private final long size;

    public SizedInputStream(File file) throws FileNotFoundException {
        this.size = file.length();
        this.parent = new FileInputStream(file);
    }

    public SizedInputStream(byte[] bytes) {
        this.size = bytes.length;
        this.parent = new ByteArrayInputStream(bytes);
    }

    public SizedInputStream(InputStream parent, long size) {
        this.parent = parent;
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public int read() throws IOException {
        return this.parent.read();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }
}

