/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.utils.tableinfo;

import com.browsersoft.config.utils.StreamUtils;
import com.browsersoft.config.utils.tableinfo.TableField;
import com.browsersoft.config.utils.tableinfo.TableFieldBlob;
import com.browsersoft.config.utils.tableinfo.TableFieldInfo;
import com.browsersoft.config.utils.tableinfo.TableFieldInfoType;
import com.browsersoft.config.utils.tableinfo.TableFieldLength;
import com.browsersoft.config.utils.tableinfo.TableIndexInfo;
import com.browsersoft.config.utils.tableinfo.TableInfo;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TableFieldInfoUtils {
    private static String EMPTY_STRING = "_EMPTY_STRING_";

    public static void main(String[] args) throws Exception {
    }

    public static void deleteEntity(ComboPooledDataSource dataSource, TableInfo tableInfo, long id) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String query = "DELETE FROM " + tableInfo.getName() + " WHERE id=?";
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            preparedStatement.setLong(1, id);
            preparedStatement.execute();
            connection.commit();
            connection.close();
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static void deleteEntityWhereFieldStringEquals(ComboPooledDataSource dataSource, TableInfo tableInfo, String columnName, String itemId) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (itemId != null && itemId.equals("")) {
                itemId = EMPTY_STRING;
            }
            String query = "DELETE FROM " + tableInfo.getName() + " WHERE field_" + columnName + "=?";
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            preparedStatement.setString(1, itemId);
            preparedStatement.execute();
            connection.commit();
            connection.close();
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static String getUpdatePreparedStatement(TableInfo tableInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE " + tableInfo.getName() + " SET ");
        boolean first = true;
        for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
            if (tableFieldInfo.getType() == TableFieldInfoType.PRIMARY_KEY) continue;
            if (!first) {
                stringBuilder.append(",");
            }
            first = false;
            stringBuilder.append(tableFieldInfo.getName());
            stringBuilder.append("=");
            stringBuilder.append("?");
        }
        return stringBuilder.toString();
    }

    public static String getInsertPreparedStatement(TableInfo tableInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO " + tableInfo.getName() + "(");
        boolean first = true;
        for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
            if (!first) {
                stringBuilder.append(",");
            }
            first = false;
            stringBuilder.append(tableFieldInfo.getName());
        }
        stringBuilder.append(") VALUES (");
        first = true;
        for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
            if (!first) {
                stringBuilder.append(",");
            }
            first = false;
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void createTable(ComboPooledDataSource dataSource, TableInfo tableInfo) throws SQLException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            Statement stmt = connection.createStatement();
            String sql = TableFieldInfoUtils.getCreateSQL(tableInfo);
            String[] command = sql.split(";");
            for (String s : command) {
                System.out.println(s);
                stmt.executeUpdate(s);
            }
            for (TableIndexInfo tableIndexInfo : tableInfo.getIndexes()) {
                stmt.executeUpdate(TableFieldInfoUtils.getCreateIndexSQL(tableInfo, tableIndexInfo));
            }
            stmt.close();
            connection.close();
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> List<T> getEntities(ComboPooledDataSource dataSource, TableInfo tableInfo, long parent) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + tableInfo.getName() + " WHERE " + tableInfo.getParentField() + "=?");
            preparedStatement.setLong(1, parent);
            List<T> ret = TableFieldInfoUtils.readResultsSet(preparedStatement.executeQuery(), tableInfo);
            connection.close();
            return ret;
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static List<String> getOneColumnForAllEntities(ComboPooledDataSource dataSource, TableInfo tableInfo, String columnName) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT field_" + columnName + " FROM " + tableInfo.getName());
            preparedStatement.executeQuery();
            ArrayList<String> ret = new ArrayList<String>();
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ret.add(resultSet.getString(1));
            }
            connection.close();
            return ret;
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> T getEntity(ComboPooledDataSource dataSource, TableInfo tableInfo, long id) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + tableInfo.getName() + " WHERE field_id=?");
            preparedStatement.setLong(1, id);
            List<T> records = TableFieldInfoUtils.readResultsSet(preparedStatement.executeQuery(), tableInfo);
            if (records.size() == 0) {
                throw new Exception("Unknown entity id:" + records);
            }
            T ret = records.get(0);
            connection.close();
            return ret;
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> T getEntityWhereFieldStringEquals(ComboPooledDataSource dataSource, TableInfo tableInfo, String fieldName, String fieldValue) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (fieldValue != null && fieldValue.equals("")) {
                fieldValue = EMPTY_STRING;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + tableInfo.getName() + " WHERE field_" + fieldName + "=?");
            preparedStatement.setString(1, fieldValue);
            List<T> records = TableFieldInfoUtils.readResultsSet(preparedStatement.executeQuery(), tableInfo);
            if (records.size() == 0) {
                throw new Exception("Unknown entity with " + fieldName + " = " + fieldValue);
            }
            T ret = records.get(0);
            connection.close();
            return ret;
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> List<T> getEntitiesWhereFieldStringEquals(ComboPooledDataSource dataSource, TableInfo tableInfo, String fieldName, String fieldValue) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (fieldValue != null && fieldValue.equals("")) {
                fieldValue = EMPTY_STRING;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + tableInfo.getName() + " WHERE field_" + fieldName + "=?");
            preparedStatement.setString(1, fieldValue);
            List<T> ret = TableFieldInfoUtils.readResultsSet(preparedStatement.executeQuery(), tableInfo);
            connection.close();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> List<T> getEntitiesWithLimit(ComboPooledDataSource dataSource, TableInfo tableInfo, String orderField, int from, int size) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String select = "select * from ( select rownum as rn,a.* from  ( select * from " + tableInfo.getName() + " ORDER BY field_" + orderField + " DESC ) a ) where rn > " + from + " AND rn <= " + (from + size);
            PreparedStatement preparedStatement = connection.prepareStatement(select);
            List<T> ret = TableFieldInfoUtils.readResultsSet(preparedStatement.executeQuery(), tableInfo);
            connection.close();
            return ret;
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> boolean existsEntityWhereFieldStringEquals(ComboPooledDataSource dataSource, TableInfo tableInfo, String fieldName, String fieldValue) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (fieldValue != null && fieldValue.equals("")) {
                fieldValue = EMPTY_STRING;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + tableInfo.getName() + " WHERE field_" + fieldName + "=?");
            preparedStatement.setString(1, fieldValue);
            List<T> records = TableFieldInfoUtils.readResultsSet(preparedStatement.executeQuery(), tableInfo);
            if (records.size() == 0) {
                connection.close();
                return false;
            }
            connection.close();
            return true;
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static void moveEntity(ComboPooledDataSource dataSource, TableInfo tableInfo, long id, long parent) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String query = "UPDATE " + tableInfo.getName() + " SET " + tableInfo.getParentField() + "=? WHERE field_id=?";
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            preparedStatement.setLong(1, parent);
            preparedStatement.setLong(2, id);
            preparedStatement.execute();
            connection.commit();
            connection.close();
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> long createEntity(ComboPooledDataSource dataSource, T record, TableInfo tableInfo) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String sqlIdentifier = "select " + tableInfo.getName() + "_sequence.nextval from dual";
            PreparedStatement pst = connection.prepareStatement(sqlIdentifier);
            ResultSet rs = pst.executeQuery();
            long newId = 0L;
            if (rs.next()) {
                newId = rs.getLong(1);
            }
            PreparedStatement preparedStatement = connection.prepareStatement(tableInfo.getInsertPreparedStatement(), 1);
            preparedStatement.setLong(1, newId);
            TableFieldInfoUtils.fillPrepareStatement(tableInfo, preparedStatement, record, 1);
            preparedStatement.execute();
            connection.commit();
            connection.close();
            return newId;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> void updateEntity(ComboPooledDataSource dataSource, T record, TableInfo tableInfo) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(tableInfo.getUpdatePreparedStatement() + " WHERE field_id=?", 1);
            int counter = TableFieldInfoUtils.fillPrepareStatement(tableInfo, preparedStatement, record, 0);
            for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
                if (tableFieldInfo.getType() != TableFieldInfoType.PRIMARY_KEY) continue;
                Field field = tableInfo.getSourceClass().getDeclaredField(tableFieldInfo.getName().replace("field_", ""));
                field.setAccessible(true);
                preparedStatement.setLong(++counter, (Long)field.get(record));
            }
            preparedStatement.execute();
            connection.commit();
            connection.close();
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static <T> void updateEntityWhereFieldStringEquals(ComboPooledDataSource dataSource, T record, TableInfo tableInfo, String fieldName, String fieldValue) throws Exception {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(tableInfo.getUpdatePreparedStatement() + " WHERE field_" + fieldName + "=?", 1);
            int counter = TableFieldInfoUtils.fillPrepareStatement(tableInfo, preparedStatement, record, 0);
            for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
                if (tableFieldInfo.getType() != TableFieldInfoType.PRIMARY_KEY) continue;
                preparedStatement.setString(++counter, fieldValue);
            }
            preparedStatement.execute();
            connection.commit();
            connection.close();
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private static <T> int fillPrepareStatement(TableInfo tableInfo, PreparedStatement preparedStatement, T record, int counter) throws Exception {
        for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
            if (tableFieldInfo.getType() == TableFieldInfoType.PRIMARY_KEY) continue;
            ++counter;
            String fieldId = tableFieldInfo.getName().replace("field_", "");
            Field field = tableInfo.getSourceClass().getDeclaredField(fieldId);
            field.setAccessible(true);
            switch (tableFieldInfo.getType()) {
                case STRING: {
                    String sv = (String)field.get(record);
                    if (sv != null && sv.equals("")) {
                        sv = EMPTY_STRING;
                    }
                    preparedStatement.setString(counter, sv);
                    break;
                }
                case LONG: {
                    preparedStatement.setLong(counter, (Long)field.get(record));
                    break;
                }
                case BOOLEAN: {
                    preparedStatement.setBoolean(counter, (Boolean)field.get(record));
                    break;
                }
                case BLOB: {
                    String s = (String)field.get(record);
                    if (s != null && s.equals("")) {
                        s = EMPTY_STRING;
                    }
                    if (s == null) {
                        preparedStatement.setBlob(counter, (Blob)null);
                        break;
                    }
                    preparedStatement.setBlob(counter, new ByteArrayInputStream(s.getBytes("UTF-8")));
                    break;
                }
                case INT: {
                    if (field.getType().isEnum()) {
                        preparedStatement.setInt(counter, TableFieldInfoUtils.encodeEnum(field, record));
                        break;
                    }
                    preparedStatement.setInt(counter, (Integer)field.get(record));
                    break;
                }
            }
        }
        return counter;
    }

    public static <T> List<T> readResultsSet(ResultSet resultSet, TableInfo tableInfo) throws Exception {
        ArrayList list = new ArrayList();
        while (resultSet.next()) {
            Object newInstance = tableInfo.getSourceClass().newInstance();
            for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
                String fieldId = tableFieldInfo.getName().replace("field_", "");
                Field field = tableInfo.getSourceClass().getDeclaredField(fieldId);
                field.setAccessible(true);
                switch (tableFieldInfo.getType()) {
                    case STRING: {
                        String s = resultSet.getString(tableFieldInfo.getName());
                        if (s != null && s.equals(EMPTY_STRING)) {
                            s = "";
                        }
                        field.set(newInstance, s);
                        break;
                    }
                    case LONG: {
                        field.set(newInstance, resultSet.getLong(tableFieldInfo.getName()));
                        break;
                    }
                    case BOOLEAN: {
                        field.set(newInstance, resultSet.getBoolean(tableFieldInfo.getName()));
                        break;
                    }
                    case BLOB: {
                        Blob blob = resultSet.getBlob(tableFieldInfo.getName());
                        if (blob == null) {
                            field.set(newInstance, null);
                            break;
                        }
                        byte[] bytes = StreamUtils.loadInputStreamToBytes(blob.getBinaryStream());
                        String value = new String(bytes, "UTF-8");
                        if (value.equals(EMPTY_STRING)) {
                            value = "";
                        }
                        field.set(newInstance, value);
                        break;
                    }
                    case INT: {
                        if (field.getType().isEnum()) {
                            field.set(newInstance, TableFieldInfoUtils.decodeEnum(field, resultSet.getInt(tableFieldInfo.getName())));
                            break;
                        }
                        field.set(newInstance, resultSet.getInt(tableFieldInfo.getName()));
                        break;
                    }
                    case PRIMARY_KEY: {
                        field.set(newInstance, resultSet.getLong(tableFieldInfo.getName()));
                    }
                }
            }
            list.add(newInstance);
        }
        return list;
    }

    public static int encodeEnum(Field field, Object record) throws IllegalAccessException {
        Class<?> myEnum = field.getType();
        ?[] constants = myEnum.getEnumConstants();
        Object value = field.get(record);
        for (int i = 0; i < constants.length; ++i) {
            if (constants[i] != value) continue;
            return i;
        }
        return 0;
    }

    public static <E extends Enum<E>> E decodeEnum(Field field, int ordinal) {
        try {
            Class<?> myEnum = field.getType();
            Method valuesMethod = myEnum.getMethod("values", new Class[0]);
            Object arrayWithEnumValies = valuesMethod.invoke(myEnum, new Object[0]);
            return (E)((Enum)Array.get(arrayWithEnumValies, ordinal));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<TableInfo> getTablesInDatabase(Connection dbConnection) throws SQLException {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        PreparedStatement preparedStatement = dbConnection.prepareStatement("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA='PUBLIC'");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String table = resultSet.getString(1);
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName(table);
            DatabaseMetaData metadata = dbConnection.getMetaData();
            ResultSet resultSet2 = metadata.getColumns(null, null, tableInfo.getName(), null);
            while (resultSet2.next()) {
                TableFieldInfo tableFieldInfo = new TableFieldInfo();
                tableFieldInfo.setName(resultSet2.getString("COLUMN_NAME"));
                String type = resultSet2.getString("TYPE_NAME");
                int size = resultSet2.getInt("COLUMN_SIZE");
                if (type.equals("INTEGER")) {
                    tableFieldInfo.setType(TableFieldInfoType.INT);
                } else if (type.equals("VARCHAR")) {
                    tableFieldInfo.setType(TableFieldInfoType.STRING);
                    tableFieldInfo.setLength(size);
                } else if (type.equals("BIGINT")) {
                    if (tableFieldInfo.getName().equals("id")) {
                        tableFieldInfo.setType(TableFieldInfoType.PRIMARY_KEY);
                    } else {
                        tableFieldInfo.setType(TableFieldInfoType.LONG);
                    }
                } else if (type.equals("BOOLEAN")) {
                    tableFieldInfo.setType(TableFieldInfoType.BOOLEAN);
                }
                tableInfo.getFields().add(tableFieldInfo);
            }
            tableInfos.add(tableInfo);
        }
        return tableInfos;
    }

    public static String getCreateIndexSQL(TableInfo tableInfo, TableIndexInfo tableIndexInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE INDEX " + tableIndexInfo.getName() + " ON " + tableInfo.getName() + "(");
        boolean first = true;
        for (String column : tableIndexInfo.getFields()) {
            if (!first) {
                stringBuilder.append(",\n        ");
            }
            first = false;
            stringBuilder.append(column);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getCreateSQL(TableInfo tableInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE " + tableInfo.getName() + "(field_id number(19,0) not null,\n       ");
        boolean first = true;
        for (TableFieldInfo tableFieldInfo : tableInfo.getFields()) {
            if (tableFieldInfo.getType() == TableFieldInfoType.PRIMARY_KEY) continue;
            if (!first) {
                stringBuilder.append(",\n        ");
            }
            first = false;
            stringBuilder.append(tableFieldInfo.getName() + " " + TableFieldInfoUtils.getOracleType(tableFieldInfo));
        }
        stringBuilder.append(", primary key (field_id));");
        stringBuilder.append("CREATE SEQUENCE " + tableInfo.getName() + "_sequence\n" + "  START WITH 1\n" + "  INCREMENT BY 1\n" + "  CACHE 100;");
        return stringBuilder.toString();
    }

    private static String getOracleType(TableFieldInfo tableFieldInfo) {
        switch (tableFieldInfo.getType()) {
            case STRING: {
                return "varchar2(" + tableFieldInfo.getLength() + " CHAR)";
            }
            case LONG: {
                return "number(19,0)";
            }
            case BLOB: {
                return "blob";
            }
            case INT: {
                return "number(10,0)";
            }
            case PRIMARY_KEY: {
                return "number(19,0)";
            }
        }
        throw null;
    }

    public static TableInfo getTableInfo(Class aClass) throws Exception {
        return TableFieldInfoUtils.getTableInfo(aClass, "parent");
    }

    public static TableInfo getTableInfo(Class aClass, String parentField) throws Exception {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setName(aClass.getSimpleName());
        tableInfo.setSourceClass(aClass);
        tableInfo.setParentField("field_" + parentField);
        TableFieldInfoUtils.classToFields(aClass, tableInfo);
        tableInfo.setInsertPreparedStatement(TableFieldInfoUtils.getInsertPreparedStatement(tableInfo));
        tableInfo.setUpdatePreparedStatement(TableFieldInfoUtils.getUpdatePreparedStatement(tableInfo));
        return tableInfo;
    }

    private static void classToFields(Class aClass, TableInfo tableInfo) throws Exception {
        for (Field field : aClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(TableField.class)) continue;
            TableFieldInfo tableFieldInfo = new TableFieldInfo();
            tableFieldInfo.setName("field_" + field.getName());
            if (field.getType().equals(String.class)) {
                tableFieldInfo.setType(TableFieldInfoType.STRING);
                if (field.isAnnotationPresent(TableFieldBlob.class)) {
                    tableFieldInfo.setType(TableFieldInfoType.BLOB);
                }
                if (field.isAnnotationPresent(TableFieldLength.class)) {
                    TableFieldLength logIndexerFieldLength = field.getAnnotation(TableFieldLength.class);
                    tableFieldInfo.setLength(logIndexerFieldLength.value());
                }
            } else if (field.getType().equals(Long.TYPE)) {
                if (field.getName().equals("id")) {
                    tableFieldInfo.setType(TableFieldInfoType.PRIMARY_KEY);
                } else {
                    tableFieldInfo.setType(TableFieldInfoType.LONG);
                }
            } else if (field.getType().equals(Byte[].class)) {
                tableFieldInfo.setType(TableFieldInfoType.BLOB);
            } else if (field.getType().equals(Boolean.TYPE)) {
                tableFieldInfo.setType(TableFieldInfoType.BOOLEAN);
            } else if (field.getType().isEnum()) {
                tableFieldInfo.setType(TableFieldInfoType.INT);
            } else if (field.getType().equals(Integer.TYPE)) {
                tableFieldInfo.setType(TableFieldInfoType.INT);
            } else {
                throw new Exception("Unknown type of field " + field.getName() + " of class " + aClass.getName());
            }
            tableInfo.getFields().add(tableFieldInfo);
        }
    }
}

