/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate;

import com.browsersoft.config.jgate.GateNode;
import com.browsersoft.config.jgate.GateServerConfiguration;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiver;
import com.browsersoft.config.jgate.comm.lowlevel.SocketSender;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.jgate.util.KeyStore;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class SocketGateNode
extends GateNode {
    private KeyStore keyStore;

    public SocketGateNode() {
    }

    public SocketGateNode(String id) {
        super(id);
    }

    public SocketGateNode(GateNodeConfiguration configuration) {
        super(configuration);
    }

    public SocketGateNode(String id, GateNodeConfiguration configuration) {
        super(id, configuration);
    }

    public void runAsServer(int port) throws Exception {
        this.addReceiver(new SocketReceiver(port, this.configuration));
    }

    public void runAsServer(int port, File keyStoreFile, String ksPass, String crPass, boolean useTLS) throws Exception {
        this.addReceiver(new SocketReceiver(port, this.configuration, keyStoreFile, ksPass, crPass, useTLS));
    }

    public void runAsServer(GateServerConfiguration gateServerConfiguration) throws Exception {
        if (gateServerConfiguration.getKeystore() == null || gateServerConfiguration.getKeystore().equals("")) {
            this.runAsServer(gateServerConfiguration.getPort());
        } else {
            this.runAsServer(gateServerConfiguration.getPort(), new File(gateServerConfiguration.getKeystore()), gateServerConfiguration.getKsPass(), gateServerConfiguration.getCrPass(), gateServerConfiguration.useTLS());
        }
    }

    public GateNodeProxy connect(String url) throws Exception {
        URL urlO = new URL(url);
        if (url.startsWith("https")) {
            return this.connect(this.createSocketSender(urlO.getHost(), urlO.getPort(), true));
        }
        return this.connect(this.createSocketSender(urlO.getHost(), urlO.getPort(), false));
    }

    public GateNodeProxy connect(String url, String user, String password) throws Exception {
        URL urlO = new URL(url);
        int port = urlO.getPort();
        if (url.startsWith("https")) {
            if (port == -1) {
                port = 443;
            }
            return this.connect(this.createSocketSender(urlO.getHost(), port, true), user, password);
        }
        if (port == -1) {
            port = 80;
        }
        return this.connect(this.createSocketSender(urlO.getHost(), port, false), user, password);
    }

    public void setPublicURL(String host, int port) throws IOException {
        this.setPublicSender(this.createSocketSender(host, port, false));
    }

    private SocketSender createSocketSender(String host, int port, boolean ssl) throws IOException {
        SocketSender socketSender = new SocketSender(host, port, ssl, this.configuration.getInt("CLIENT_DUMMY_REQUEST_PERIOD", 0), this.keyStore);
        return socketSender;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }
}

