/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.classloading;

import com.browsersoft.config.jgate.classloading.Base64Coder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JarFileInfo {
    private File file;
    private String md5;

    public JarFileInfo(File file) throws Exception {
        this.file = file;
        this.md5 = JarFileInfo.computeHash(new FileInputStream(file));
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static String computeHash(InputStream s) throws IOException {
        int ret;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = new byte[4096];
        while ((ret = s.read(buffer)) >= 0) {
            md.update(buffer, 0, ret);
        }
        byte[] hash = md.digest();
        return new String(new Base64Coder().encode(hash));
    }
}

