/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.classloading;

import com.browsersoft.config.jgate.annotations.GateMethod;
import com.browsersoft.config.jgate.classloading.JarFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class JarsStorageService {
    private Map<String, JarFileInfo[]> services = new HashMap<String, JarFileInfo[]>();

    @GateMethod
    public String[] getJarsIdsForService(String serviceName) throws Exception {
        if (!this.services.containsKey(serviceName)) {
            return null;
        }
        JarFileInfo[] jars = this.services.get(serviceName);
        String[] ids = new String[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            ids[i] = jars[i].getMd5();
        }
        return ids;
    }

    @GateMethod
    public InputStream getJar(String id, String serviceName) throws Exception {
        JarFileInfo[] jars;
        if (!this.services.containsKey(serviceName)) {
            throw new Exception("Service with name \"" + serviceName + "\"not found");
        }
        for (JarFileInfo fileInfo : jars = this.services.get(serviceName)) {
            if (!fileInfo.getMd5().equals(id)) continue;
            return new FileInputStream(fileInfo.getFile());
        }
        throw new Exception("Jar with id \"" + id + "\"not found");
    }

    public void registerServiceJars(String serviceName, File[] jars) throws Exception {
        if (this.services.containsKey(serviceName)) {
            this.services.remove(serviceName);
        }
        JarFileInfo[] fileInfos = new JarFileInfo[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            fileInfos[i] = new JarFileInfo(jars[i]);
        }
        this.services.put(serviceName, fileInfos);
    }
}

