/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.lowlevel;

import com.browsersoft.config.jgate.comm.lowlevel.Constants;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiver;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiverThread;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.util.Arrays;
import com.browsersoft.config.jgate.util.KeyStore;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SocketReceiverMainThread
extends Thread {
    private SocketReceiver socketReceiver;
    private int port;
    private GateNodeConfiguration configuration;
    private File keyStoreFile;
    private String ksPass;
    private String crPass;
    private boolean useTLS;
    ServerSocket serverSocket;

    public SocketReceiverMainThread(SocketReceiver socketReceiver, int port, GateNodeConfiguration configuration) {
        this.socketReceiver = socketReceiver;
        this.port = port;
        this.configuration = configuration;
    }

    public SocketReceiverMainThread(SocketReceiver socketReceiver, int port, GateNodeConfiguration configuration, File keyStoreFile, String ksPass, String crPass, boolean useTLS) {
        this.socketReceiver = socketReceiver;
        this.port = port;
        this.configuration = configuration;
        this.keyStoreFile = keyStoreFile;
        this.ksPass = ksPass;
        this.crPass = crPass;
        this.useTLS = useTLS;
    }

    @Override
    public void run() {
        try {
            this.serverSocket = null;
            if (this.keyStoreFile != null) {
                KeyStore keyStore = new KeyStore(this.keyStoreFile, this.ksPass, this.crPass, null);
                SSLContext sslContext = keyStore.createSSLContext("TLS");
                SSLServerSocketFactory ssf = sslContext.getServerSocketFactory();
                this.serverSocket = ssf.createServerSocket(this.port);
                if (this.serverSocket instanceof SSLServerSocket) {
                    SSLServerSocket sslServerSocket = (SSLServerSocket)this.serverSocket;
                    String[] enabledProtocols = Arrays.intersection(sslServerSocket.getEnabledProtocols(), Constants.enabledProtocols);
                    if (enabledProtocols.length == 0) {
                        enabledProtocols = new String[]{"TLSv1.2"};
                    }
                    sslServerSocket.setEnabledProtocols(enabledProtocols);
                    if (this.useTLS) {
                        sslServerSocket.setWantClientAuth(true);
                        sslServerSocket.setNeedClientAuth(true);
                    }
                }
            } else {
                this.serverSocket = new ServerSocket(this.port, 50);
            }
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket nextClientSock = this.serverSocket.accept();
                    SocketReceiverThread thread = new SocketReceiverThread(nextClientSock, this.socketReceiver);
                    thread.start();
                }
                catch (Exception nextClientSock) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }
}

