/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.middlelevel;

import com.browsersoft.config.jgate.comm.lowlevel.RequestType;
import com.browsersoft.config.jgate.comm.lowlevel.Sender;
import com.browsersoft.config.jgate.comm.lowlevel.SizeLimitInputStream;
import com.browsersoft.config.jgate.comm.lowlevel.SocketReceiverThread;
import com.browsersoft.config.jgate.comm.lowlevel.SocketSender;
import com.browsersoft.config.jgate.comm.lowlevel.StreamsPair;
import com.browsersoft.config.jgate.comm.middlelevel.GateSender;
import com.browsersoft.config.jgate.comm.middlelevel.GateSenderHandler;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateResponseWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressState;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressSwitchers;
import com.browsersoft.config.jgate.comm.middlelevel.request.BeginCallMethodGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.CancelProgressGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ClientCallingsGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ClientLoginGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ClientLogoutGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.CloseStreamGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.EndCallMethodGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRoutePath;
import com.browsersoft.config.jgate.comm.middlelevel.request.GetProxiesGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.PingGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ProgressGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ReadFromInputStreamGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.ReadResponseBytesGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.SendingBytesGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.SimpleCallMethodGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.request.WriteToOutputStreamGateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.response.BytesGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ClientCallingsGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ExceptionGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.IdAndSizeGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.IdGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.OKGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ProgressGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ProxyInfosGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.ReturnedObjectGateResponse;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.exceptions.GateException;
import com.browsersoft.config.jgate.proxy.ServiceProxyInfo;
import com.browsersoft.config.jgate.proxy.handlers.SyncMethodHandler;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.utils.ProgressHandler;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class GateSenderImpl
implements GateSender {
    private GateSenderHandler handler;
    private GateNodeConfiguration configuration;
    private String gateNodeId;

    public GateSenderImpl(GateNodeConfiguration configuration, String gateNodeId) {
        this.configuration = configuration;
        this.gateNodeId = gateNodeId;
    }

    @Override
    public Object callMethod(MethodCalling methodCalling, Object[] extraParams, ProgressSwitchers progressSwitchers, SyncMethodHandler handler, GateRoutePath routePath) throws Exception {
        return this.doCallMethod(methodCalling, extraParams, progressSwitchers, handler, routePath);
    }

    public InputStream readFromInputStream(String id, GateRoutePath routePath) throws Exception {
        ReadFromInputStreamGateRequest request = new ReadFromInputStreamGateRequest();
        request.setId(id);
        return this.callGateForInputStream(request, routePath);
    }

    public OutputStream writeToOutputStream(String id, GateRoutePath routePath) throws Exception {
        WriteToOutputStreamGateRequest request = new WriteToOutputStreamGateRequest();
        request.setId(id);
        return this.callGateForOutputStream(request, routePath).getOutput();
    }

    public void closeStream(String id, GateRoutePath routePath) throws Exception {
        this.doCloseStreamGateRequest(id, routePath);
    }

    @Override
    public String clientLogin(Sender sender, String gateNodeId, GateRoutePath routePath) throws Exception {
        return this.doClientLoginGateRequest(sender, gateNodeId, routePath);
    }

    @Override
    public void clientLogout(String id, GateRoutePath routePath) throws Exception {
        this.doClientLogoutGateRequest(id, routePath);
    }

    @Override
    public List<GateRequestWithId> checkClientCalling(String clientId, List<GateResponseWithId> responses, GateRoutePath routePath) throws Exception {
        return this.doCheckClientCallingGateRequest(clientId, responses, routePath);
    }

    @Override
    public void ping(GateRoutePath gateRoutePath) throws Exception {
        this.callGate(new PingGateRequest(), GateResponse.TypeOfResponse.OK, gateRoutePath);
    }

    public Object doCallMethod(MethodCalling methodCalling, Object[] extraParams, ProgressSwitchers progressSwitchers, SyncMethodHandler handler, GateRoutePath routePath) throws Exception {
        if (methodCalling.getRequestType() == RequestType.READ_FROM_INPUTSTREAM) {
            SimpleCallMethodGateRequest request = new SimpleCallMethodGateRequest();
            request.setMethodParams(methodCalling);
            return this.callGateForInputStream(request, routePath);
        }
        if (methodCalling.getRequestType() == RequestType.WRITE_TO_OUTPUTSTREAM) {
            this.doSimpleOutputStreamWriteGateRequest(methodCalling, routePath, extraParams);
            return null;
        }
        GateResponse gateResponse = progressSwitchers.isUseStreamForRequest() ? this.processStreamRequest(progressSwitchers.isUseStreamForResponse(), handler, methodCalling, progressSwitchers.isHandleProgress(), routePath) : this.doSimpleCallMethodGateRequest(methodCalling, progressSwitchers.isUseStreamForResponse(), progressSwitchers.isHandleProgress(), routePath);
        if (progressSwitchers.isHandleProgress()) {
            ProgressState state;
            String progressId = ((IdGateResponse)gateResponse).getId();
            int sleepTime = this.configuration.getInt("GATE_SENDER_PROGRESS_THREAD_SLEEP", 300);
            do {
                boolean shouldContinue;
                Thread.sleep(sleepTime);
                state = this.doProgressStateGateRequest(progressId, routePath);
                if (handler == null || (shouldContinue = state.generateEvents(handler))) continue;
                state = this.doCancelProgressGateRequest(progressId, routePath);
            } while (!state.isItFinish());
            if (state.getState() == ProgressState.ProgressStateType.FINISH_WITH_ERROR) {
                throw new InvocationTargetException((Throwable)state.getObject());
            }
            if (progressSwitchers.isUseStreamForResponse()) {
                return this.processStreamResponse(handler, methodCalling, state.getIdOfResponseStream(), state.getSizeOfResponse(), routePath);
            }
            return state.getObject();
        }
        if (progressSwitchers.isUseStreamForResponse()) {
            IdAndSizeGateResponse idGateResponse = (IdAndSizeGateResponse)gateResponse;
            return this.processStreamResponse(handler, methodCalling, idGateResponse.getId(), idGateResponse.getSizeOfResponse(), routePath);
        }
        return ((ReturnedObjectGateResponse)gateResponse).getObject();
    }

    private Object processStreamResponse(SyncMethodHandler handler, MethodCalling methodCalling, String id, int size, GateRoutePath gateRoutePath) throws Exception {
        BytesGateResponse response;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (handler != null) {
            handler.callingMethodInProgress(SyncMethodHandler.ProgressType.RECEIVING_RESPONSE, 0, "Start receiving response of method \"" + methodCalling.getMethod() + "\"");
        }
        int pointer = 0;
        do {
            response = this.doReadResponseBytesGateRequest(id, gateRoutePath);
            byte[] retBytes = response.getBytes();
            try {
                byteArrayOutputStream.write(retBytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot write to ByteArrayOutputStream .", e);
            }
            pointer += retBytes.length;
            if (handler == null) continue;
            handler.callingMethodInProgress(SyncMethodHandler.ProgressType.RECEIVING_RESPONSE, Math.round((float)pointer / (float)size * 100.0f), "Receiving response of method \"" + methodCalling.getMethod() + "\"");
        } while (response.hasMoreBytes());
        if (handler != null) {
            handler.callingMethodInProgress(SyncMethodHandler.ProgressType.RECEIVING_RESPONSE, 100, "Finish receiving response of method \"" + methodCalling.getMethod() + "\"");
        }
        byte[] returnedObjectAsByteArray = byteArrayOutputStream.toByteArray();
        return GateUtils.deserializeByteArrayToObject(returnedObjectAsByteArray);
    }

    private GateResponse processStreamRequest(boolean useStreamForResponse, SyncMethodHandler handler, MethodCalling methodCalling, boolean handleProgress, GateRoutePath gateRoutePath) throws Exception {
        int bufferSize = this.configuration.getInt("STREAM_PARAMS_BUFFER_SIZE", 4096);
        if (handler == null || !handler.callingMethodInProgress(SyncMethodHandler.ProgressType.SENDING_PARAMS, 0, "Start calling method \"" + methodCalling.getMethod() + "\"")) {
            // empty if block
        }
        byte[] methodParamsAsBytesArray = GateUtils.serializeObjectToByteArray(methodCalling);
        String id = this.doBeginCallMethodGateRequest(gateRoutePath);
        int pointer = 0;
        byte[] sendBuffer = new byte[bufferSize];
        while (pointer + sendBuffer.length <= methodParamsAsBytesArray.length) {
            System.arraycopy(methodParamsAsBytesArray, pointer, sendBuffer, 0, sendBuffer.length);
            this.doSendBytesGateRequest(id, sendBuffer, gateRoutePath);
            if (handler == null || handler.callingMethodInProgress(SyncMethodHandler.ProgressType.SENDING_PARAMS, Math.round((float)(pointer += sendBuffer.length) / (float)methodParamsAsBytesArray.length * 100.0f), "Calling method \"" + methodCalling.getMethod() + "\"")) continue;
        }
        if (pointer < methodParamsAsBytesArray.length) {
            byte[] shorterSendBuffer = new byte[methodParamsAsBytesArray.length - pointer];
            System.arraycopy(methodParamsAsBytesArray, pointer, shorterSendBuffer, 0, shorterSendBuffer.length);
            this.doSendBytesGateRequest(id, shorterSendBuffer, gateRoutePath);
        }
        GateResponse gateResponse = this.doEndCallMethodGateRequest(id, useStreamForResponse, handleProgress, gateRoutePath);
        if (handler == null || !handler.callingMethodInProgress(SyncMethodHandler.ProgressType.SENDING_PARAMS, 100, "Finish calling method \"" + methodCalling.getMethod() + "\"")) {
            // empty if block
        }
        return gateResponse;
    }

    private GateResponse doSimpleCallMethodGateRequest(MethodCalling methodCalling, boolean useStreamForResponse, boolean handleProgress, GateRoutePath routePath) throws Exception {
        SimpleCallMethodGateRequest request = new SimpleCallMethodGateRequest();
        request.setMethodParams(methodCalling);
        request.setHandleProgress(handleProgress);
        request.setUseStreamForResponse(useStreamForResponse);
        if (handleProgress) {
            return this.callGate(request, GateResponse.TypeOfResponse.ID, routePath);
        }
        if (useStreamForResponse) {
            return this.callGate(request, GateResponse.TypeOfResponse.ID_AND_SIZE, routePath);
        }
        return this.callGate(request, GateResponse.TypeOfResponse.RETURNED_OBJECT, routePath);
    }

    @Override
    public List<ServiceProxyInfo> getProxyInfos(GateRoutePath routePath) throws Exception {
        return this.callGetProxyInfos(routePath);
    }

    private List<ServiceProxyInfo> callGetProxyInfos(GateRoutePath routePath) throws Exception {
        ProxyInfosGateResponse response = (ProxyInfosGateResponse)this.callGate(new GetProxiesGateRequest(), GateResponse.TypeOfResponse.PROXY_INFOS, routePath);
        return response.getProxyInfos();
    }

    private List<GateRequestWithId> doCheckClientCallingGateRequest(String clientId, List<GateResponseWithId> responses, GateRoutePath routePath) throws Exception {
        ClientCallingsGateRequest request = new ClientCallingsGateRequest();
        request.setResponses(responses);
        request.setClientId(clientId);
        return ((ClientCallingsGateResponse)this.callGate(request, GateResponse.TypeOfResponse.CLIENT_CALLINGS, routePath)).getRequests();
    }

    private void doClientLogoutGateRequest(String id, GateRoutePath gateRoutePath) throws Exception {
        ClientLogoutGateRequest request = new ClientLogoutGateRequest();
        request.setId(id);
        this.callGate(request, GateResponse.TypeOfResponse.OK, gateRoutePath);
    }

    private String doClientLoginGateRequest(Sender sender, String gateNodeId, GateRoutePath gateRoutePath) throws Exception {
        ClientLoginGateRequest request = new ClientLoginGateRequest();
        request.setSender(sender);
        request.setGateNodeId(gateNodeId);
        if (gateRoutePath != null) {
            request.setRealClient(false);
        } else {
            request.setRealClient(true);
        }
        IdGateResponse idGateResponse = (IdGateResponse)this.callGate(request, GateResponse.TypeOfResponse.ID, gateRoutePath);
        return idGateResponse.getId();
    }

    private OKGateResponse doCloseStreamGateRequest(String id, GateRoutePath gateRoutePath) throws Exception {
        CloseStreamGateRequest request = new CloseStreamGateRequest();
        request.setId(id);
        return (OKGateResponse)this.callGate(request, GateResponse.TypeOfResponse.OK, gateRoutePath);
    }

    private BytesGateResponse doReadResponseBytesGateRequest(String id, GateRoutePath gateRoutePath) throws Exception {
        ReadResponseBytesGateRequest request = new ReadResponseBytesGateRequest();
        request.setId(id);
        return (BytesGateResponse)this.callGate(request, GateResponse.TypeOfResponse.BYTES, gateRoutePath);
    }

    private String doBeginCallMethodGateRequest(GateRoutePath gateRoutePath) throws Exception {
        return ((IdGateResponse)this.callGate(new BeginCallMethodGateRequest(), GateResponse.TypeOfResponse.ID, gateRoutePath)).getId();
    }

    private ProgressState doCancelProgressGateRequest(String progressId, GateRoutePath gateRoutePath) throws Exception {
        CancelProgressGateRequest request = new CancelProgressGateRequest();
        request.setId(progressId);
        return ((ProgressGateResponse)this.callGate(request, GateResponse.TypeOfResponse.PROGRESS, gateRoutePath)).getProgressState();
    }

    private ProgressState doProgressStateGateRequest(String id, GateRoutePath gateRoutePath) throws Exception {
        ProgressGateRequest progressStateGateRequest = new ProgressGateRequest();
        progressStateGateRequest.setId(id);
        return ((ProgressGateResponse)this.callGate(progressStateGateRequest, GateResponse.TypeOfResponse.PROGRESS, gateRoutePath)).getProgressState();
    }

    private GateResponse doEndCallMethodGateRequest(String id, boolean useStreamForResponse, boolean handleProgress, GateRoutePath gateRoutePath) throws Exception {
        EndCallMethodGateRequest gateRequest = new EndCallMethodGateRequest();
        gateRequest.setId(id);
        gateRequest.setHandleProgress(handleProgress);
        gateRequest.setUseStreamForResponse(useStreamForResponse);
        if (handleProgress) {
            return this.callGate(gateRequest, GateResponse.TypeOfResponse.ID, gateRoutePath);
        }
        if (useStreamForResponse) {
            return this.callGate(gateRequest, GateResponse.TypeOfResponse.ID_AND_SIZE, gateRoutePath);
        }
        return this.callGate(gateRequest, GateResponse.TypeOfResponse.RETURNED_OBJECT, gateRoutePath);
    }

    private void doSendBytesGateRequest(String id, byte[] bytes, GateRoutePath gateRoutePath) throws Exception {
        SendingBytesGateRequest request = new SendingBytesGateRequest();
        request.setId(id);
        request.setBytes(bytes);
        this.callGate(request, GateResponse.TypeOfResponse.OK, gateRoutePath);
    }

    private GateResponse callGate(GateRequest request, GateResponse.TypeOfResponse expectedType, GateRoutePath routePath) throws Exception {
        request.setPath(routePath);
        request.setGateNodeId(this.gateNodeId);
        GateResponse gateResponse = this.handler.sendRequest(request);
        if (expectedType != null && gateResponse.getTypeOfResponse() != expectedType) {
            throw new GateCommException("Unexpected gate response \"" + gateResponse.getClass().getName() + "\"");
        }
        return gateResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSimpleOutputStreamWriteGateRequest(MethodCalling methodCalling, GateRoutePath routePath, Object[] extraParams) throws Exception {
        StreamsPair streamsPair = null;
        try {
            SimpleCallMethodGateRequest request = new SimpleCallMethodGateRequest();
            request.setMethodParams(methodCalling);
            SizedInputStream inputStream = (SizedInputStream)extraParams[0];
            ProgressHandler handler = (ProgressHandler)extraParams[1];
            long size = inputStream.getSize();
            streamsPair = this.callGateForOutputStream(request, routePath);
            streamsPair.getOutput().write(SocketSender.longToBytes(size));
            GateUtils.inputStreamToOutputStreamWithHandler((InputStream)inputStream, streamsPair.getOutput(), handler, size, 1024);
            long inLength = SocketReceiverThread.readLength(streamsPair.getInput());
            SizeLimitInputStream in = new SizeLimitInputStream(streamsPair.getInput(), inLength);
            Object res = GateUtils.deserializeInputStreamToObject(in);
            if (!(res instanceof GateResponse)) {
                throw new GateCommException("Invalid returned class \"" + res.getClass().getName() + "\"");
            }
            GateResponse gateResponse = (GateResponse)res;
            if (gateResponse.getTypeOfResponse() == GateResponse.TypeOfResponse.EXCEPTION) {
                ExceptionGateResponse exceptionGateResponse = (ExceptionGateResponse)gateResponse;
                Throwable t = exceptionGateResponse.getException();
                if (t instanceof GateException) {
                    throw (GateException)t;
                }
                throw new InvocationTargetException(t);
            }
        }
        finally {
            if (streamsPair != null) {
                try {
                    streamsPair.getOutput().close();
                }
                catch (IOException iOException) {}
                try {
                    streamsPair.getInput().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public InputStream callGateForInputStream(GateRequest request, GateRoutePath routePath) throws Exception {
        request.setPath(routePath);
        request.setGateNodeId(this.gateNodeId);
        return this.handler.sendInputStreamRequest(request);
    }

    public StreamsPair callGateForOutputStream(GateRequest request, GateRoutePath routePath) throws Exception {
        request.setPath(routePath);
        request.setGateNodeId(this.gateNodeId);
        return this.handler.sendOutputStreamRequest(request);
    }

    @Override
    public void setHandler(GateSenderHandler handler) {
        this.handler = handler;
    }

    @Override
    public GateSenderHandler getHandler() {
        return this.handler;
    }

    public GateNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GateNodeConfiguration configuration) {
        this.configuration = configuration;
    }
}

