/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.comm.middlelevel.base;

import com.browsersoft.config.jgate.comm.lowlevel.RequestType;
import com.browsersoft.config.jgate.util.GateUtils;
import java.io.IOException;
import java.io.Serializable;

public class MethodCalling
implements Serializable {
    private String instanceName;
    private String method;
    private byte[] paramsAsBytes;
    private String user;
    private String password;
    private int requestType = RequestType.NORMAL;
    private Object stream;

    public MethodCalling() {
    }

    public MethodCalling(String instanceName, String method, Object[] params) throws IOException {
        this.instanceName = instanceName;
        this.method = method;
        this.paramsAsBytes = GateUtils.serializeObjectToByteArray(params);
    }

    public MethodCalling(String instanceName, String method, Object[] params, int requestType) throws IOException {
        this.instanceName = instanceName;
        this.method = method;
        this.paramsAsBytes = GateUtils.serializeObjectToByteArray(params);
        this.requestType = requestType;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Object[] getParams(ClassLoader classLoader) throws ClassNotFoundException, IOException {
        Object[] call = (Object[])GateUtils.deserializeByteArrayToObject(this.paramsAsBytes, classLoader);
        if (this.requestType == RequestType.WRITE_TO_OUTPUTSTREAM) {
            Object[] extendedCall = new Object[call.length + 1];
            for (int i = 0; i < call.length; ++i) {
                extendedCall[i] = call[i];
            }
            extendedCall[extendedCall.length - 1] = this.stream;
            return extendedCall;
        }
        return call;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public Object getStream() {
        return this.stream;
    }

    public void setStream(Object stream) {
        this.stream = stream;
    }
}

