/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.generator;

import com.browsersoft.config.jgate.annotations.GateClass;
import com.browsersoft.config.jgate.annotations.GateMethod;
import com.browsersoft.config.jgate.annotations.HandleProgress;
import com.browsersoft.config.jgate.annotations.StreamReceiving;
import com.browsersoft.config.jgate.annotations.StreamSending;
import com.browsersoft.config.jgate.comm.middlelevel.base.MethodCalling;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressSwitchers;
import com.browsersoft.config.jgate.proxy.ServiceCallMethodHandler;
import com.browsersoft.config.jgate.proxy.ServiceProxy;
import com.browsersoft.config.jgate.proxy.handlers.AsyncHandler;
import com.browsersoft.config.jgate.proxy.handlers.AsyncMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.AsyncProgressMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncProgressMethodHandler;
import com.browsersoft.config.jgate.proxy.progress.ProgressWorker;
import com.browsersoft.config.jgate.util.GateUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GeneratorUtils {
    private static final String CATCH_TEMPLATE = "catch_template.txt";

    public static void generatePackage(String packagee, StringBuffer buffer) {
        buffer.append("package ").append(packagee).append(";\n\n");
    }

    public static void generateImports(StringBuffer buffer) {
        buffer.append("import ").append(ServiceProxy.class.getName()).append(";\n");
        buffer.append("import ").append(MethodCalling.class.getName()).append(";\n");
        buffer.append("import ").append(ProgressSwitchers.class.getName()).append(";\n");
        buffer.append("import ").append(AsyncHandler.class.getName()).append(";\n");
        buffer.append("import ").append(AsyncMethodHandler.class.getName()).append(";\n");
        buffer.append("import ").append(AsyncProgressMethodHandler.class.getName()).append(";\n");
        buffer.append("import ").append(SyncMethodHandler.class.getName()).append(";\n");
        buffer.append("import ").append(SyncProgressMethodHandler.class.getName()).append(";\n");
        buffer.append("import ").append(ProgressWorker.class.getName()).append(";\n\n");
        buffer.append("import ").append("com.browsersoft.config.jgate.exceptions.*").append(";\n\n");
    }

    public static void generateClassHeader(String proxyClassName, Class clazz, StringBuffer buffer, String extendsName) {
        buffer.append("public class ").append(proxyClassName).append(" extends ").append(extendsName);
        GateClass classAnnotation = clazz.getAnnotation(GateClass.class);
        if (classAnnotation != null && classAnnotation.value().length > 0) {
            buffer.append(" implements ");
            for (int i = 0; i < classAnnotation.value().length; ++i) {
                Class aClass = classAnnotation.value()[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(aClass.getName());
            }
        }
        buffer.append(" {\n\n");
    }

    public static List<Method> getGateMethods(Class clazz) {
        Method[] methods;
        ArrayList<Method> methodsList = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (method.getAnnotation(GateMethod.class) == null) continue;
            methodsList.add(method);
        }
        return methodsList;
    }

    public static void generateEndOfClass(StringBuffer buffer) {
        buffer.append("}\n\n");
    }

    public static void generateMethodWithWorker(StringBuffer buffer, Method method, String returnedTypeAsString, List<String> paramClasses, boolean async) {
        buffer.append("            final Object[] objects = ");
        GeneratorUtils.generateObjectsParams(buffer, 0, paramClasses.size());
        buffer.append(";\n            ");
        GeneratorUtils.generateReturn(buffer, returnedTypeAsString);
        buffer.append("doWorkerProgress( new  ").append(ProgressWorker.class.getSimpleName()).append("() {\n                public Object callMethodInWorker() throws Exception {\n                    ");
        if (returnedTypeAsString.equals("void") || async) {
            buffer.append("return ");
        } else {
            GeneratorUtils.generateReturn(buffer, returnedTypeAsString);
        }
        GeneratorUtils.generateCallMethodWithWorker(buffer, method, paramClasses.size(), true, async);
        buffer.append(";\n                }\n            },  ");
        if (async) {
            buffer.append("(").append(AsyncProgressMethodHandler.class.getSimpleName()).append(")");
        } else {
            buffer.append("(").append(SyncProgressMethodHandler.class.getSimpleName()).append(")");
        }
        buffer.append(" handler);\n");
    }

    public static void generateMethodWithHandler(StringBuffer buffer, Method method, String returnedTypeAsString, List<String> paramClasses, List<String> extraParamClasses, int requestType) throws Exception {
        GeneratorUtils.generateMethodHeader(buffer, GeneratorUtils.getTypeAsString(method.getGenericReturnType()), method, paramClasses, extraParamClasses, false, SyncMethodHandler.class.getSimpleName());
        GeneratorUtils.generateTry(buffer);
        buffer.append("        if ( handler instanceof ").append(SyncProgressMethodHandler.class.getSimpleName()).append(" ) {\n");
        GeneratorUtils.generateMethodWithWorker(buffer, method, returnedTypeAsString, paramClasses, false);
        buffer.append("        } else {\n            ");
        GeneratorUtils.generateReturn(buffer, returnedTypeAsString);
        GeneratorUtils.generateCallMethod(buffer, method, paramClasses.size(), extraParamClasses.size(), true, false, requestType);
        buffer.append(";\n");
        buffer.append("        }\n");
        GeneratorUtils.generateCatch(buffer, method);
        buffer.append("    }\n\n");
        GeneratorUtils.generateMethodHeader(buffer, "String", method, paramClasses, extraParamClasses, true, AsyncMethodHandler.class.getSimpleName());
        GeneratorUtils.generateTry(buffer);
        buffer.append("        if ( handler instanceof ").append(AsyncProgressMethodHandler.class.getSimpleName()).append(" ) {\n");
        GeneratorUtils.generateMethodWithWorker(buffer, method, "String", paramClasses, true);
        buffer.append("        } else {\n            ");
        buffer.append("return ");
        GeneratorUtils.generateCallMethod(buffer, method, paramClasses.size(), extraParamClasses.size(), true, true, requestType);
        buffer.append(";\n");
        buffer.append("        }\n");
        GeneratorUtils.generateCatch(buffer, method);
        buffer.append("    }\n\n");
    }

    private static void generateTry(StringBuffer buffer) {
        buffer.append("        try {\n");
    }

    private static void generateCatch(StringBuffer buffer, Method method) throws Exception {
        InputStream stream = GeneratorUtils.class.getResourceAsStream(CATCH_TEMPLATE);
        String catchTemplate = GeneratorUtils.loadInputStreamToString(stream);
        StringBuilder sb = new StringBuilder();
        for (Class<?> exception : method.getExceptionTypes()) {
            sb.append("            if (e.getCause() instanceof " + exception.getName() + ")\n");
            sb.append("                throw (" + exception.getName() + ") e.getCause();\n");
        }
        buffer.append(catchTemplate.replace("$DECLARED_EXCEPTIONS", sb));
    }

    private static String loadInputStreamToString(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GateUtils.inputStreamToOutputStream(stream, bos, 4096);
        return new String(bos.toByteArray(), "UTF-8");
    }

    public static void generateNormalMethod(StringBuffer buffer, Method method, String returnedTypeAsString, List<String> paramClasses, List<String> extraParamClasses, int requestType) throws Exception {
        GeneratorUtils.generateMethodHeader(buffer, returnedTypeAsString, method, paramClasses, extraParamClasses, false, null);
        GeneratorUtils.generateTry(buffer);
        buffer.append("            ");
        GeneratorUtils.generateReturn(buffer, returnedTypeAsString);
        GeneratorUtils.generateCallMethod(buffer, method, paramClasses.size(), extraParamClasses.size(), false, false, requestType);
        buffer.append(";\n");
        GeneratorUtils.generateCatch(buffer, method);
        buffer.append("    }\n\n");
        GeneratorUtils.generateMethodHeader(buffer, "String", method, paramClasses, extraParamClasses, true, AsyncHandler.class.getSimpleName());
        GeneratorUtils.generateTry(buffer);
        buffer.append("            return ");
        GeneratorUtils.generateCallMethod(buffer, method, paramClasses.size(), extraParamClasses.size(), true, true, requestType);
        buffer.append(";\n");
        GeneratorUtils.generateCatch(buffer, method);
        buffer.append("    }\n\n");
    }

    public static void generateMethodHeader(StringBuffer buffer, String returnTypeAsString, Method method, List<String> paramClasses, List<String> extraParamClasses, boolean async, String handlerClass) {
        ArrayList<String> finalParamClasses = new ArrayList<String>(paramClasses);
        finalParamClasses.addAll(extraParamClasses);
        buffer.append("    public ");
        buffer.append(returnTypeAsString);
        buffer.append(" ");
        buffer.append(method.getName());
        if (async) {
            buffer.append("Async");
        }
        buffer.append("( ");
        for (int i = 0; i < finalParamClasses.size(); ++i) {
            buffer.append((String)finalParamClasses.get(i));
            buffer.append(" ");
            buffer.append("param").append(i);
            if (i == finalParamClasses.size() - 1) continue;
            buffer.append(", ");
        }
        if (handlerClass != null) {
            if (paramClasses.size() > 0) {
                buffer.append(", ");
            }
            buffer.append("final ").append(handlerClass).append(" handler");
        }
        GeneratorUtils.generateExceptions(buffer, method);
        buffer.append(" { \n");
    }

    public static boolean needMethodHandler(Method method) {
        return method.getAnnotation(StreamSending.class) != null || method.getAnnotation(StreamReceiving.class) != null || method.getAnnotation(HandleProgress.class) != null;
    }

    public static List<String> resolveParameters(Method method) {
        Type[] paramTypes = method.getGenericParameterTypes();
        ArrayList<String> ret = new ArrayList<String>();
        for (Type type : paramTypes) {
            String typeAsString = GeneratorUtils.getTypeAsString(type);
            if (typeAsString.equals(ServiceCallMethodHandler.class.getName()) || typeAsString.equals("java.io.InputStream") || typeAsString.equals("java.io.OutputStream")) continue;
            ret.add(typeAsString);
        }
        return ret;
    }

    public static List<String> resolveParametersProgress(Method method) {
        Type[] paramTypes = method.getGenericParameterTypes();
        ArrayList<String> ret = new ArrayList<String>();
        for (Type type : paramTypes) {
            String typeAsString = GeneratorUtils.getTypeAsString(type);
            if (typeAsString.equals(ServiceCallMethodHandler.class.getName())) continue;
            ret.add(typeAsString);
        }
        return ret;
    }

    public static void generateCallMethod(StringBuffer buffer, Method method, int size, int extraSize, boolean handler, boolean async, int requestType) {
        int offset = size--;
        if (requestType == 2) {
            --offset;
            ++extraSize;
        }
        buffer.append("callMethod");
        if (async) {
            buffer.append("Async");
        }
        buffer.append("(\n                        ");
        GeneratorUtils.generateMethodCalling(buffer, method, size, requestType);
        buffer.append(",\n                        ");
        GeneratorUtils.generateObjectsParams(buffer, offset, extraSize);
        buffer.append(",\n                        ");
        GeneratorUtils.generateProgressSwitchers(buffer, method);
        buffer.append(",\n                        ");
        if (handler) {
            buffer.append("handler");
        } else {
            buffer.append("null");
        }
        buffer.append(")");
    }

    public static void generateCallMethodWithWorker(StringBuffer buffer, Method method, int size, boolean handler, boolean async) {
        buffer.append("callMethod");
        if (async) {
            buffer.append("Async");
        }
        buffer.append("(\n                        ");
        GeneratorUtils.generateMethodCallingWithWorker(buffer, method, size);
        buffer.append(",\n                        ");
        GeneratorUtils.generateProgressSwitchers(buffer, method);
        buffer.append(",\n                        ");
        if (handler) {
            buffer.append("handler");
        } else {
            buffer.append("null");
        }
        buffer.append(")");
    }

    public static void generateMethodCalling(StringBuffer buffer, Method method, int size, int requestType) {
        buffer.append("new MethodCalling(nameOfInstance, \"" + method.getName() + "\", ");
        GeneratorUtils.generateObjectsParams(buffer, 0, size);
        buffer.append(",");
        buffer.append(requestType);
        buffer.append(")");
    }

    public static void generateMethodCallingWithWorker(StringBuffer buffer, Method method, int size) {
        buffer.append("new MethodCalling(nameOfInstance, \"" + method.getName() + "\", objects )");
    }

    public static void generateProgressSwitchers(StringBuffer buffer, Method method) {
        buffer.append("new ProgressSwitchers(");
        if (method.getAnnotation(StreamSending.class) != null) {
            buffer.append("true");
        } else {
            buffer.append("false");
        }
        if (method.getAnnotation(StreamReceiving.class) != null) {
            buffer.append(", true");
        } else {
            buffer.append(", false");
        }
        if (method.getAnnotation(HandleProgress.class) != null) {
            buffer.append(", true");
        } else {
            buffer.append(", false");
        }
        buffer.append(")");
    }

    public static void generateEndOfCallMethodWithThis(StringBuffer buffer, Method method) {
        if (method.getAnnotation(StreamSending.class) != null) {
            buffer.append(", true");
        } else {
            buffer.append(", false");
        }
        if (method.getAnnotation(StreamReceiving.class) != null) {
            buffer.append(", true");
        } else {
            buffer.append(", false");
        }
        if (method.getAnnotation(HandleProgress.class) != null) {
            buffer.append(", true");
        } else {
            buffer.append(", false");
        }
        buffer.append(", this");
        buffer.append(" );\n");
    }

    public static void generateObjectsParams(StringBuffer buffer, int offset, int size) {
        buffer.append(" new Object[] { ");
        for (int i = 0; i < size; ++i) {
            buffer.append("param").append(i + offset);
            if (i == size - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" }");
    }

    public static void generateReturn(StringBuffer buffer, String returnedTypeAsString) {
        if (!returnedTypeAsString.equals("void")) {
            HashMap<String, String> m2 = new HashMap<String, String>();
            m2.put("void", "");
            m2.put("boolean", "return (Boolean)");
            m2.put("byte", "return (Byte)");
            m2.put("char", "return (Character)");
            m2.put("short", "return (Short)");
            m2.put("int", "return (Integer)");
            m2.put("long", "return (Long)");
            m2.put("float", "return (Float)");
            m2.put("double", "return (Double)");
            if (m2.containsKey(returnedTypeAsString)) {
                buffer.append((String)m2.get(returnedTypeAsString));
            } else {
                buffer.append("return (");
                buffer.append(returnedTypeAsString);
                buffer.append(")");
            }
            buffer.append(" ");
        }
    }

    public static void generateExceptions(StringBuffer buffer, Method method) {
        Class<?>[] originalMethodExceptions;
        ArrayList<String> exceptionList = new ArrayList<String>();
        for (Class<?> exceptionType : originalMethodExceptions = method.getExceptionTypes()) {
            exceptionList.add(exceptionType.getName());
        }
        buffer.append(" ) ");
        if (exceptionList.size() > 0) {
            buffer.append("throws ");
        }
        for (int j = 0; j < exceptionList.size(); ++j) {
            String e = (String)exceptionList.get(j);
            if (j > 0) {
                buffer.append(", ");
            }
            buffer.append(e);
        }
    }

    public static String getTypeAsString(Type returnedType) {
        String returnedTypeAsString = returnedType.toString();
        returnedTypeAsString = returnedTypeAsString.replaceFirst("^class ", "");
        returnedTypeAsString = returnedTypeAsString.replaceFirst("^interface ", "");
        HashMap<String, String> signatureToType = new HashMap<String, String>();
        signatureToType.put("[Ljava.lang.String;", "String[]");
        signatureToType.put("[[B", "byte[][]");
        signatureToType.put("[B", "byte[]");
        if (signatureToType.containsKey(returnedTypeAsString)) {
            returnedTypeAsString = (String)signatureToType.get(returnedTypeAsString);
        }
        if ((returnedTypeAsString = returnedTypeAsString.replace('$', '.')).startsWith("java.lang.")) {
            returnedTypeAsString = returnedTypeAsString.substring("java.lang.".length());
        }
        return returnedTypeAsString;
    }
}

