/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.generator;

import com.browsersoft.config.jgate.annotations.UserName;
import com.browsersoft.config.jgate.comm.lowlevel.RequestType;
import com.browsersoft.config.jgate.generator.GeneratorUtils;
import com.browsersoft.config.jgate.proxy.ServiceProxy;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ProxyGenerator {
    public static String generateProxyJava(String proxyClassName, String packagee, Class clazz) throws Exception {
        StringBuffer buffer = new StringBuffer();
        GeneratorUtils.generatePackage(packagee, buffer);
        GeneratorUtils.generateImports(buffer);
        GeneratorUtils.generateClassHeader(proxyClassName, clazz, buffer, ServiceProxy.class.getSimpleName());
        List<Method> methods = GeneratorUtils.getGateMethods(clazz);
        for (Method method : methods) {
            String returnedTypeAsString = GeneratorUtils.getTypeAsString(method.getGenericReturnType());
            int requestType = RequestType.NORMAL;
            Type[] paramTypes = method.getGenericParameterTypes();
            String lastParam = null;
            if (paramTypes.length > 0) {
                lastParam = GeneratorUtils.getTypeAsString(paramTypes[paramTypes.length - 1]);
            }
            String preLastParam = null;
            if (paramTypes.length > 1) {
                preLastParam = GeneratorUtils.getTypeAsString(paramTypes[paramTypes.length - 2]);
            }
            if (lastParam != null && lastParam.equals("com.browsersoft.config.utils.streams.SizedInputStream")) {
                requestType = RequestType.WRITE_TO_OUTPUTSTREAM;
                returnedTypeAsString = "void";
            } else if (returnedTypeAsString.equals("com.browsersoft.config.utils.streams.SizedInputStream")) {
                requestType = RequestType.READ_FROM_INPUTSTREAM;
            }
            List<String> paramClasses = GeneratorUtils.resolveParameters(method);
            UserName userName = method.getAnnotation(UserName.class);
            if (userName != null) {
                paramClasses.remove(paramClasses.size() - 1);
            }
            ArrayList<String> extraParamClasses = new ArrayList<String>();
            if (requestType == RequestType.WRITE_TO_OUTPUTSTREAM) {
                extraParamClasses.add("com.browsersoft.config.utils.ProgressHandler");
            }
            if (GeneratorUtils.needMethodHandler(method)) {
                GeneratorUtils.generateMethodWithHandler(buffer, method, returnedTypeAsString, paramClasses, extraParamClasses, RequestType.NORMAL);
                continue;
            }
            GeneratorUtils.generateNormalMethod(buffer, method, returnedTypeAsString, paramClasses, extraParamClasses, requestType);
        }
        GeneratorUtils.generateEndOfClass(buffer);
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.out.println("USAGE: generate <proxyClassName> <package> <class name> <file> ");
            System.out.println("Wrong number of arguments!");
            return;
        }
        if (args.length == 4) {
            String source = ProxyGenerator.generateProxyJava(args[0], args[1], Class.forName(args[2]));
            FileOutputStream fileOutputStream = new FileOutputStream(args[3]);
            fileOutputStream.write(source.getBytes());
            fileOutputStream.close();
            System.out.println("Done!");
        }
    }
}

