/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.comm.lowlevel.Sender;
import com.browsersoft.config.jgate.comm.lowlevel.StreamsPair;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.response.ExceptionGateResponse;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.exceptions.GateException;
import com.browsersoft.config.jgate.node.GateNodeProxyServant;
import com.browsersoft.config.jgate.util.GateUtils;
import com.browsersoft.config.utils.streams.SizedInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class DirectAccessGateNodeProxyServant
implements GateNodeProxyServant {
    private Sender sender;

    public DirectAccessGateNodeProxyServant(Sender sender) {
        this.sender = sender;
    }

    @Override
    public SizedInputStream sendInputStreamRequest(GateRequest request) throws Exception {
        byte[] bytes = GateUtils.serializeObjectToByteArray(request);
        return this.sender.readFromInputStream(bytes);
    }

    @Override
    public StreamsPair sendOutputStreamRequest(GateRequest request) throws Exception {
        byte[] bytes = GateUtils.serializeObjectToByteArray(request);
        return this.sender.writeToOutputStream(bytes);
    }

    @Override
    public synchronized GateResponse sendRequest(GateRequest request) throws Exception {
        Object res;
        byte[] bytes = GateUtils.serializeObjectToByteArray(request);
        try {
            res = this.sender.sendBytesAndReturnObject(bytes);
        }
        catch (IOException e) {
            try {
                this.sender.reconnect();
                res = this.sender.sendBytesAndReturnObject(bytes);
            }
            catch (IOException e2) {
                throw e;
            }
        }
        if (!(res instanceof GateResponse)) {
            throw new GateCommException("Invalid returned class \"" + res.getClass().getName() + "\"");
        }
        GateResponse gateResponse = (GateResponse)res;
        if (gateResponse.getTypeOfResponse() == GateResponse.TypeOfResponse.EXCEPTION) {
            ExceptionGateResponse exceptionGateResponse = (ExceptionGateResponse)gateResponse;
            Throwable t = exceptionGateResponse.getException();
            if (t instanceof GateException) {
                throw (GateException)t;
            }
            throw new InvocationTargetException(t);
        }
        return gateResponse;
    }
}

