/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.node;

import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.comm.middlelevel.response.GateResponse;
import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.repositories.gaterequests.GateRequestRepository;
import com.browsersoft.config.jgate.repositories.gaterequests.GateResponseReceiver;

public class VirtualCallingGateNodeProxyServantProcess
implements GateResponseReceiver {
    private String clientId;
    private GateRequestRepository requestRepository;
    private GateResponse gateResponse;
    private GateNodeConfiguration configuration;

    public GateResponse sendRequest(GateRequest request) throws Exception {
        this.requestRepository.newRequest(this.clientId, request, this);
        int timeOut = this.configuration.getInt("CLIENT_CALLING_TIMEOUT", 20000);
        int timeOutCheckSleep = this.configuration.getInt("CLIENT_CALLING_TIMEOUT_CHECK_SLEEP", 200);
        long before = System.currentTimeMillis();
        while (this.gateResponse == null && System.currentTimeMillis() - before < (long)timeOut) {
            Thread.sleep(timeOutCheckSleep);
        }
        if (this.gateResponse == null) {
            throw new Exception("Time exceeded");
        }
        return this.gateResponse;
    }

    @Override
    public void responseReceived(GateResponse gateResponse) throws Exception {
        this.gateResponse = gateResponse;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GateRequestRepository getRequestRepository() {
        return this.requestRepository;
    }

    public void setRequestRepository(GateRequestRepository requestRepository) {
        this.requestRepository = requestRepository;
    }

    public GateNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GateNodeConfiguration configuration) {
        this.configuration = configuration;
    }
}

