/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.proxy.progress;

import com.browsersoft.config.jgate.exceptions.GateCommException;
import com.browsersoft.config.jgate.proxy.handlers.SyncMethodHandler;
import com.browsersoft.config.jgate.proxy.handlers.SyncProgressMethodHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressDialog
extends JDialog
implements SyncProgressMethodHandler {
    private boolean canceled;
    private Timer timer;
    private int percent = 0;
    private String text = "";
    private JButton buttonCancel;
    private JLabel labelText;
    private JProgressBar progressBar;

    @Override
    public void progressStart() {
        this.runTimer();
        this.setVisible(true);
    }

    public ProgressDialog(Frame owner) {
        super(owner, true);
        this.centerParent();
        this.initComponents("Long method calling", false);
        this.runTimer();
    }

    public ProgressDialog(String title, Frame owner) {
        super(owner, true);
        this.centerParent();
        this.initComponents(title, false);
        this.runTimer();
    }

    public ProgressDialog(String title, Frame owner, boolean withoutCancel) {
        super(owner, true);
        this.centerParent();
        this.initComponents(title, withoutCancel);
        this.runTimer();
    }

    @Override
    public void progressFinish() {
        this.timer.stop();
        this.dispose();
    }

    @Override
    public boolean callingMethodInProgress(SyncMethodHandler.ProgressType progressType, int percent, String message) throws GateCommException {
        String progressTypeAsString = "";
        switch (progressType) {
            case PROCESSING_METHOD: {
                progressTypeAsString = "Procesing method: ";
            }
        }
        this.percent = percent;
        this.text = progressTypeAsString + message;
        return !this.canceled;
    }

    private void runTimer() {
        this.timer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.progressBar.setIndeterminate(ProgressDialog.this.percent < 0);
                if (ProgressDialog.this.percent < 0) {
                    ProgressDialog.this.progressBar.setValue(0);
                    ProgressDialog.this.progressBar.setString("");
                } else {
                    ProgressDialog.this.progressBar.setValue(ProgressDialog.this.percent);
                    ProgressDialog.this.progressBar.setString(ProgressDialog.this.percent + "%");
                }
                if (ProgressDialog.this.text.equals("")) {
                    ProgressDialog.this.text = " ";
                }
                ProgressDialog.this.labelText.setText(ProgressDialog.this.text);
            }
        });
        this.timer.start();
    }

    private void initComponents(String title, boolean withoutCancel) {
        this.labelText = new JLabel();
        this.progressBar = new JProgressBar();
        this.buttonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setResizable(false);
        this.labelText.setText(" ");
        this.labelText.setBounds(10, 10, 570, 20);
        this.progressBar.setBackground(new Color(255, 255, 255));
        this.progressBar.setForeground(new Color(255, 153, 51));
        this.progressBar.setStringPainted(true);
        this.progressBar.setBounds(10, 40, 570, 20);
        if (!withoutCancel) {
            this.buttonCancel.setText("Cancel");
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProgressDialog.this.cancel();
                }
            });
            this.buttonCancel.setBounds(250, 70, 100, 20);
        }
        this.add(this.labelText);
        this.add(this.progressBar);
        this.add(this.buttonCancel);
        this.setLayout(null);
        this.setSize(new Dimension(600, 140));
    }

    private void cancel() {
        this.canceled = true;
    }

    public void centerParent() {
        try {
            Container myParent = this.getParent();
            Point topLeft = myParent.getLocationOnScreen();
            Dimension parentSize = myParent.getSize();
            Dimension mySize = this.getSize();
            int x = parentSize.width > mySize.width ? (parentSize.width - mySize.width) / 2 + topLeft.x : topLeft.x;
            int y = parentSize.height > mySize.height ? (parentSize.height - mySize.height) / 2 + topLeft.y : topLeft.y;
            this.setLocation(x, y);
            this.requestFocus();
        }
        catch (Exception e) {
            Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(SCREEN_SIZE.width / 2 - this.getWidth() / 2, SCREEN_SIZE.height / 2 - this.getHeight() / 2);
            this.requestFocus();
        }
    }
}

