/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.clients;

import com.browsersoft.config.jgate.configuration.GateNodeConfiguration;
import com.browsersoft.config.jgate.node.GateNodeProxyServant;
import com.browsersoft.config.jgate.proxy.DirectGateNodeProxy;
import com.browsersoft.config.jgate.proxy.GateNodeProxy;
import com.browsersoft.config.jgate.repositories.clients.ClientsRepositoryHandler;
import com.browsersoft.config.jgate.repositories.clients.ClientsRepositoryItem;
import com.browsersoft.config.jgate.repositories.clients.ClientsRepositoryThread;
import java.util.ArrayList;
import java.util.List;

public class ClientsRepository {
    private List<ClientsRepositoryItem> items = new ArrayList<ClientsRepositoryItem>();
    private GateNodeConfiguration configuration;
    private ClientsRepositoryThread repositoryThread;
    private ClientsRepositoryHandler handler;

    public ClientsRepository(GateNodeConfiguration configuration) {
        this.configuration = configuration;
        this.repositoryThread = new ClientsRepositoryThread(this, configuration);
        this.repositoryThread.setDaemon(true);
    }

    public boolean updateLastAccess(String id) {
        ClientsRepositoryItem item = this.getItemWithId(id);
        if (item != null) {
            item.setLastAccess(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public synchronized void checkExpiration() {
        int clientTimeout = this.configuration.getInt("CLIENT_REPOSITORY_TIMEOUT", 5000);
        for (int i = this.items.size() - 1; i >= 0; --i) {
            ClientsRepositoryItem item = this.items.get(i);
            if (!item.isUseExpiration() || System.currentTimeMillis() - item.getLastAccess() <= (long)clientTimeout) continue;
            this.items.remove(item);
            if (this.handler == null) continue;
            this.handler.clientDisconnected(item.getId());
        }
    }

    public synchronized void addItem(String id, String gateId, GateNodeProxyServant servant, boolean useExpiration) {
        ClientsRepositoryItem clientsRepositoryItem = new ClientsRepositoryItem();
        clientsRepositoryItem.setServant(servant);
        clientsRepositoryItem.setId(id);
        clientsRepositoryItem.setGateId(gateId);
        clientsRepositoryItem.setUseExpiration(useExpiration);
        clientsRepositoryItem.setLastAccess(System.currentTimeMillis());
        if (this.handler != null) {
            this.handler.clientConnected(id);
        }
        this.items.add(clientsRepositoryItem);
    }

    public synchronized List<GateNodeProxy> toNodeProxies(String myGateNodeId) throws Exception {
        ArrayList<GateNodeProxy> proxies = new ArrayList<GateNodeProxy>();
        for (ClientsRepositoryItem item : this.items) {
            if (item.getGateNodeProxy() == null) {
                DirectGateNodeProxy gateNodeProxy = new DirectGateNodeProxy(item.getServant(), this.configuration, item.getGateId(), "");
                item.setGateNodeProxy(gateNodeProxy);
            }
            proxies.add(item.getGateNodeProxy());
        }
        return proxies;
    }

    public synchronized ClientsRepositoryItem getItem(String id) {
        return this.getItemWithId(id);
    }

    public ClientsRepositoryItem getItemWithId(String id) {
        for (ClientsRepositoryItem item : this.items) {
            if (item.getId() == null) {
                return null;
            }
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public synchronized void removeItem(String id) {
        for (ClientsRepositoryItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            this.items.remove(item);
            if (this.handler != null) {
                this.handler.clientDisconnected(id);
            }
            return;
        }
    }

    public ClientsRepositoryHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ClientsRepositoryHandler handler) {
        this.handler = handler;
    }
}

