/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.gaterequests;

import com.browsersoft.config.jgate.comm.middlelevel.base.GateRequestWithId;
import com.browsersoft.config.jgate.comm.middlelevel.base.GateResponseWithId;
import com.browsersoft.config.jgate.comm.middlelevel.request.GateRequest;
import com.browsersoft.config.jgate.repositories.gaterequests.GateRequestRepositoryItem;
import com.browsersoft.config.jgate.repositories.gaterequests.GateResponseReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GateRequestRepository {
    private Map<String, GateRequestRepositoryItem> map = new HashMap<String, GateRequestRepositoryItem>();

    public synchronized void newRequest(String clientId, GateRequest request, GateResponseReceiver handler) throws Exception {
        if (!this.map.containsKey(clientId)) {
            GateRequestRepositoryItem repositoryItem = new GateRequestRepositoryItem();
            this.map.put(clientId, repositoryItem);
        }
        this.map.get(clientId).addRequest(request, handler);
    }

    public synchronized void clearRequestsForId(String clientId) {
        if (this.map.containsKey(clientId)) {
            this.map.remove(clientId);
        }
    }

    public synchronized void responsesReceived(String clientId, List<GateResponseWithId> responseWithIdList) throws Exception {
        if (!this.map.containsKey(clientId)) {
            return;
        }
        this.map.get(clientId).responsesReceived(responseWithIdList);
        if (this.map.get(clientId).isEmpty()) {
            this.map.remove(clientId);
        }
    }

    public synchronized List<GateRequestWithId> getRequestsForClient(String clientId) {
        if (!this.map.containsKey(clientId)) {
            return new ArrayList<GateRequestWithId>();
        }
        return this.map.get(clientId).getRequests();
    }
}

