/*
 * Decompiled with CFR 0.152.
 */
package com.browsersoft.config.jgate.repositories.progress;

import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressState;
import com.browsersoft.config.jgate.comm.middlelevel.base.ProgressStateItem;
import com.browsersoft.config.jgate.util.GateUtils;
import java.util.HashMap;

public class ProgressRepository {
    private HashMap<String, ProgressState> map = new HashMap();

    public synchronized String newState() {
        ProgressState progressState = new ProgressState();
        String uid = GateUtils.generateUUID();
        this.map.put(uid, progressState);
        return uid;
    }

    public synchronized ProgressState cloneState(String id) {
        ProgressState progressState = this.checkProgressState(id);
        ProgressState clone = progressState.cloneState();
        progressState.getItems().clear();
        return clone;
    }

    public synchronized void addState(String id, ProgressStateItem item) {
        ProgressState progressState = this.checkProgressState(id);
        progressState.getItems().add(item);
    }

    public synchronized void finishWithError(String id, Exception e) {
        ProgressState s = this.checkProgressState(id);
        s.setObject(e);
        s.setState(ProgressState.ProgressStateType.FINISH_WITH_ERROR);
    }

    public synchronized void addRunning(String id, int percent, String message) {
        ProgressState s = this.checkProgressState(id);
        ProgressStateItem progressItem = new ProgressStateItem();
        progressItem.setMessage(message);
        progressItem.setPercent(percent);
        s.getItems().add(progressItem);
    }

    public synchronized void finishWithReturnedObject(String id, Object returned) {
        ProgressState s = this.checkProgressState(id);
        s.setObject(returned);
        s.setState(ProgressState.ProgressStateType.FINISH_WITH_RETURNED_OBJECT);
    }

    public synchronized void finishWithReturnedStream(String id, String idOfStream, int size) {
        ProgressState s = this.checkProgressState(id);
        s.setIdOfResponseStream(idOfStream);
        s.setSizeOfResponse(size);
        s.setState(ProgressState.ProgressStateType.FINISH_WITH_RETURNED_STREAM);
    }

    public ProgressState getState(String id) {
        return this.checkProgressState(id);
    }

    private ProgressState checkProgressState(String id) {
        if (!this.map.containsKey(id)) {
            throw new RuntimeException("Progress state with id \"" + id + "\" doesn't exist");
        }
        return this.map.get(id);
    }
}

