
@echo off

setlocal EnableDelayedExpansion

set JAVA=java.exe
set JAVA_OPTS=-Xmx512M -XX:PermSize=512M -XX:MaxPermSize=512m -Duser.timezone=UTC -Djava.awt.headless=true
set NODEDIR=%~dp0
set LOGSDIR=%NODEDIR%\logs
set LOGSLIMIT=14

:run_node

if not exist "%LOGSDIR%" (
	mkdir "%LOGSDIR%"
)

if exist "%NODEDIR%\node.out" (

	echo.
	echo Rotating logs ...

	set LASTLOGFILE=%LOGSDIR%\node.out.%LOGSLIMIT%

    if exist "!LASTLOGFILE!" (
        del "!LASTLOGFILE!"
    )

    for /L %%i in (%LOGSLIMIT%, -1, 1) do (

        set /a j=%%i+1

        set LOGFILE1=%LOGSDIR%\node.out.%%i
        set LOGFILE2=%LOGSDIR%\node.out.!j!

        if exist "!LOGFILE1!" (
			move "!LOGFILE1!" "!LOGFILE2!"
        )

    )

    move "%NODEDIR%\node.out" "%LOGSDIR%\node.out.1"

)

if exist "%NODEDIR%\deploy\libs" (

    echo.
    echo Upgrading Release node ...

    rmdir /S /Q "%NODEDIR%\libs"
    move "%NODEDIR%\deploy\libs" "%NODEDIR%"

)

echo.
echo Starting Release Node ...

%JAVA% %JAVA_OPTS% -classpath "libs/*" com.browsersoft.config.node.ReleaseNode "%NODEDIR%\server.xml" > "%NODEDIR%\node.out" 2>&1

echo Release node terminated ... Restarting in 120 seconds ...
timeout 120

goto run_node
